package pl.fabrykagier.eduFarma.processess 
{
	import flash.display.MovieClip;
	import pl.fabrykagier.eduFarma.main.MainGameClass;
	import pl.fabrykagier.eduFarma.main.StructureGraphics;
	import pl.fabrykagier.eduFarma.main.UserData;
	import pl.fabrykagier.engines.tEngine.PlaceableObject;
	
	/**
	 * This handles upgrading of buildings.
	 * @author Andrzej Kaczor
	 */
	public class ProcessUpgrade extends ProcessBase
	{		
		private var processTime:int;
		private var totalTime:int;
		private var _upgradeLevel:int;
		private var _upgradeTime:int;
		private var costPerUpdate:int;
		private var processProgress:int = 0;
		
		/**
		 * Constructor. Handles necessary process parameters and calculations.
		 * @param	buildingID - the ID of the building which starts the process
		 * @param	structure - reference to the building object
		 * @param	upgradeLevel - level to which the building should be upgraded 
		 * @param	upgradeTime - how long will the upgrade process take (in seconds)
		 * @param	upgradeCost - how much will the upgrade process cost
		 */
		public function ProcessUpgrade(buildingID:int, structure:PlaceableObject, upgradeLevel:int, upgradeTime:int, upgradeCost:int, startPoint:int=0) 
		{
			super(buildingID, structure);
			
			_processType = "upgrade";
			
			// set variables
			this._upgradeTime = upgradeTime;
			this._upgradeLevel = upgradeLevel;
			
			// set process time
			processTime = _upgradeTime;
			totalTime = processTime;			
			
			if (startPoint > 0) processTime -= Math.round(processTime * (startPoint / 100));
			
			// calculate how much will money be decreased by after every process update
			//costPerUpdate = Math.round(upgradeCost / upgradeTime);
			
			if(MainGameClass.FLAG_dataRestored) UserData.getInstance.money -= upgradeCost;
						
			if (upgradeLevel == 1)
			{
				if(MainGameClass.FLAG_dataRestored) UserData.getInstance.buildingsCost += upgradeCost;
			}
			else
			{
				if(MainGameClass.FLAG_dataRestored) UserData.getInstance.upgradesCost += upgradeCost;
			}
			
			// if the object has a dbID property, this means this isn't the initial building process and the upgrade extension should be called
			if (structure.objectSpecificContent.dbID >= 0 && MainGameClass.FLAG_dataRestored)
			{
				// so call the extension
				MainGameClass.getInstance.communicator.callExtension("buildingsExt", "upgradeBuilding", { dbId:structure.objectSpecificContent.dbID, structureID:_buildingID, newLevel:_upgradeLevel, totalTime:totalTime, userId:UserData.getInstance.userDbID } );
			}
		}
		
		/**
		 * Updates the process state. Called by a timer/enter frame function invoked by the creator of this process.
		 */
		override public function update():void
		{
			// decrease time
			processTime--;
			
			// decrease money
			//UserData.getInstance.money = UserData.getInstance.money - costPerUpdate;		
			
			// update the progress status icon
			_progress = Math.round(((totalTime - processTime) / totalTime) * 100);
			StructureGraphics(_structure.objectFace).statusIcon.update(progress);
			
			if (MainGameClass.getInstance.tooltip && MainGameClass.getInstance.tooltipID == structure.ID)
			{
				MainGameClass.getInstance.tooltip.updateTimer(processTime);
			}
						
			// if time has run out
			if (processTime <= 0)
			{
				// make sure the building is fully visible and at the correct frame
				structure.objectFace.gotoAndStop("lvl" + upgradeLevel.toString());
				StructureGraphics(structure.objectFace).setStatus("idle");
				
				if (MainGameClass.getInstance.tooltip && MainGameClass.getInstance.tooltipID == structure.ID)
				{
					MainGameClass.getInstance.tooltip.updateText("", "Nieaktywny\n");
				}
				
				MainGameClass.getInstance.communicator.callExtension("buildingsExt", "nullProgress", { dbId:structure.objectSpecificContent.dbID, userId:UserData.getInstance.userDbID } );
				
				// end the process
				endProcess();
				return;
			}
		}
		
		public function get upgradeLevel():int { return _upgradeLevel; }
		
		public function set upgradeLevel(value:int):void 
		{
			_upgradeLevel = value;
		}
		
		public function get upgradeTime():int { return _upgradeTime; }
		
		public function set upgradeTime(value:int):void 
		{
			_upgradeTime = value;
		}
		
	}

}