package pl.fabrykagier.engines.tEngine 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.utils.getDefinitionByName;
	import flash.xml.XMLNode;
	import flash.filters.GlowFilter;
	import pl.fabrykagier.eduFarma.gameData.StructureData;
	import pl.fabrykagier.eduFarma.main.StructureGraphics;
	
	/**
	 * Represents object which can be added, placed, moved and removed from game grid.
	 * @author Andrzej Kaczor
	 */
	public class PlaceableObject extends ObjectBase
	{
		private var _objectSettings:Array /* of Strings */ = [];
		private var _objectFace:StructureGraphics;
		private var _ID:int;
		private var _tileEngineInstance:TileEngine;
		private var glowFilter:GlowFilter = new GlowFilter(0xFFFFFF, 1, 8, 8, 4);
		private var _objectSpecificContent:StructureData = null;
		
		public var FLAG_placeableInPlace:Boolean = false;
		public var FLAG_objectPrepared:Boolean = false;
		private var _objectName:String;
		private var _typeId:int;
		
		/**
		 * Class constructor
		 * @param	objectName
		 */
		public function PlaceableObject(typeId:int, tileEngineInstance:TileEngine) 
		{
			this._typeId = typeId;
			this._tileEngineInstance = tileEngineInstance;
			
			mouseChildren = true;
			
			getSettings(typeId);
			
			super();
		}
		
		/**
		 * Reads specific settings for this object from an xml file.
		 * @param objectName - name of the object for which settings should be loaded
		 */
		public function getSettings(typeId:int):void
		{
			for each (var settingsObject:Object in EngineSettings.PLACEABLE_SETTINGS)
			{
				if (int(settingsObject.objectSettings["typeId"]) == typeId)
				{
					objectSettings = settingsObject.objectSettings;					
					break;
				}
			}			
			
			applyLoadedSettings();
		}	
		
		/**
		 * Settings have been loaded, apply some of them to the object.
		 */
		private function applyLoadedSettings():void 
		{
			objectFace = StructureGraphics(new (getDefinitionByName(objectSettings["graphicAssetName"]) as Class)());
			objectFace.x = 0;
			objectFace.y = 0;
			this.addChild(objectFace);
			objectFace.addStatusIcon();
						
			if(positionOnGridX < 0)	positionOnGridX = 1;
			if(positionOnGridY < 0) positionOnGridY = 1;
			
			if(!FLAG_placeableInPlace) objectFace.alpha = 0.5;
			
			FLAG_objectPrepared = true;			
		}
		
		/**
		 * Updates necessary object properties
		 */
		public function update():void
		{
			if (!FLAG_placeableInPlace && FLAG_objectPrepared)
			{
				var newX:Number = this.parent.mouseX - this.width / 2;
				var newY:Number;
				
				if (objectFace.getBounds(this).topLeft.y < -this.height / 2) newY = this.parent.mouseY + (objectSettings["baseSizeY"]/2) * EngineSettings.TILE_HEIGHT;
				else newY = this.parent.mouseY - (objectSettings["baseSizeY"]/2) * EngineSettings.TILE_HEIGHT;
				
				if (newX < 0)
				{
					newX = 0;
				}
				else if (newX > (EngineSettings.GRID_WIDTH - objectSettings["baseSizeX"]) * EngineSettings.TILE_WIDTH)
				{
					newX = (EngineSettings.GRID_WIDTH - objectSettings["baseSizeX"]) * EngineSettings.TILE_WIDTH;
				}
				
				if (newY < 0)
				{
					newY = 0;
				}
				else if (newY > (EngineSettings.GRID_HEIGHT - objectSettings["baseSizeY"]) * EngineSettings.TILE_HEIGHT)
				{
					newY = (EngineSettings.GRID_HEIGHT - objectSettings["baseSizeY"]) * EngineSettings.TILE_HEIGHT;
				}
				
				this.x = newX;
				this.y = newY;
				
				var gridCoords:Point = _tileEngineInstance.translateCoordsToGrid(new Point(newX - EngineSettings.TILE_WIDTH/2, newY - EngineSettings.TILE_HEIGHT/2), this.parent);
				positionOnGridX = gridCoords.x;
				positionOnGridY = gridCoords.y;
				
				_tileEngineInstance.highlightTiles(gridCoords, objectSettings["baseSizeY"], objectSettings["baseSizeX"]);
			}
		}
		
		/**
		 * Handles clicking on PlaceableObject. If the object is in unfixed position state, this metod fixes the position of the object to last grid coordinates.
		 * If the object was already in place actions specific to this object are taken.
		 */
		public function placeableClicked():void
		{
			if (!FLAG_placeableInPlace)
			{				
				setInPlace(positionOnGridX, positionOnGridY);			
			}
		}
		
		public function setInPlace(gridX:int,gridY:int):void
		{
			positionOnGridX = gridX;
			positionOnGridY = gridY;
			
			this.x = (positionOnGridX) * EngineSettings.TILE_WIDTH;
			this.y = (positionOnGridY) * EngineSettings.TILE_HEIGHT;
			
			if(objectFace) objectFace.alpha = 1;
			
			this.mouseEnabled = true;
			this.mouseChildren = true;
			
			_tileEngineInstance.clearHighlight();
			FLAG_placeableInPlace = true;
			
			_tileEngineInstance.setDisplayOrder();
			
			StructureGraphics.FLAG_statusVisible = true;
			
			if (objectSettings["type"] == "storage") objectFace.isWarehouse = true;
			
			this.dispatchEvent(new Event("placeableReady"));
		}
		
		/**
		 * Add a glow filter when this object is selected
		 */
		public function glow():void
		{
			if(objectFace.getBitmap().alpha == 1) objectFace.filters = [glowFilter];
		}
		
		/**
		 * Remove the glow
		 */
		public function unglow():void
		{
			objectFace.filters = [];
		}
		
		/**
		 * Get this object's ID
		 */
		public function get ID():int { return _ID; }
		
		/**
		 * Set this object's ID
		 */
		public function set ID(value:int):void 
		{
			_ID = value;
		}
		
		public function get objectSettings():Array { return _objectSettings; }
		
		public function set objectSettings(value:Array):void 
		{
			_objectSettings = value;
		}
		
		public function get objectSpecificContent():StructureData { return _objectSpecificContent; }
		
		public function set objectSpecificContent(value:StructureData):void 
		{
			_objectSpecificContent = value;
		}
		
		public function get objectFace():StructureGraphics { return _objectFace; }
		
		public function set objectFace(value:StructureGraphics):void 
		{
			_objectFace = value;
		}
		
		public function get objectName():String { return _objectName; }
		
		public function set objectName(value:String):void 
		{
			_objectName = value;
		}
		
		public function get typeId():int { return _typeId; }
		
		public function set typeId(value:int):void 
		{
			_typeId = value;
		}
		
	}

}