package pl.fabrykagier.engines.tEngine.tiles 
{
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.utils.getDefinitionByName;
	import tileEngine.tiles.*;
	
	/**
	 * Manages background tile graphics and behavior.
	 * @author Andrzej Kaczor
	 */
	public class BackgroundTile extends MovieClip
	{
		private var tileGraphics:MovieClip;		
		private var classRef:String;
		
		/**
		 * Class constructor.
		 * @param	graphicsContainerClass - class name of the object in the library containing tile graphics. If it's empty, default class name "BGTile" will be used.
		 */
		public function BackgroundTile(graphicsContainerClass:String = "") 
		{	
			BGTile;
			
			if (graphicsContainerClass == "") classRef = "BGTile";
			else classRef = graphicsContainerClass;
			
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);			
		}
		
		/**
		 * Adds tile graphics when this object is added to display list.
		 * @param	e
		 */
		private function addedToStageHandler(e:Event):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);		
			
			tileGraphics = MovieClip(new (this.loaderInfo.applicationDomain.getDefinition("tileEngine.tiles." + classRef) as Class)());
			tileGraphics.x = 0;
			tileGraphics.y = 0;
			this.addChild(tileGraphics);
		}
		
	}

}