<?php

function teacherUpdate($request) {
    if (empty($request->data['name']) ||
        empty($request->data['surname']) ||
        empty($request->data['email']) ||
        empty($request->data['school_id']) ||
        !is_numeric($request->data['school_id']) ||
        empty($request->data['id']) ||
        !is_numeric($request->data['id']))
            return new Error(ExError::ERR_REQUEST);

    $schoolModel    = BaseModel::load('school');
    $teacherModel   = BaseModel::load('teacher');

    if (!$teacherModel->exists($request->data['id']))
        return new Error(ExError::ERR_TEACHER_NOT_EXISTS);

    if (!$schoolModel->exists($request->data['school_id']))
        return new Error(ExError::ERR_TEACHER_SCHOOL_NOT_FOUND);

    return $teacherModel->save($request->data);
}
