<?php

class SchoolClass extends BaseModel
{
    public function exists($id) {
        return $this->executeGetValue('SELECT id FROM class WHERE id = :id', array(
            'id'    => $id
        )) !== false;
    }

    
    public function existsByNameAndSchool($name, $school_id) {
        return $this->executeGetValue('SELECT id FROM school WHERE name = :name AND school_id = :school_id', array(
            'name'          => $name,
            'school_id'     => $school_id
        )) !== false;
    }


    public function save($row) {
        $this->execute('
            INSERT INTO class
            SET
                id = :id,
                name = :name,
                school_id = :school_id,
                teacher_id = :teacher_id,
                room_name = :room_name,
                tutorial = 1,
                max_users = 999
            ON DUPLICATE KEY UPDATE
                id = :id,
                name = :name,
                school_id = :school_id,
                teacher_id = :teacher_id,
                room_name = :room_name
        ', $row);

        return $row;
    }


    public function delete($id) {
        //delete class
        $this->execute('DELETE FROM class WHERE id = :id', array(
            'id'    => $id
        ));

        //delete students
        $this->execute('DELETE FROM student WHERE class_id = :class_id', array(
            'class_id'      => $id
        ));
    }


    public function get($id) {
        return $this->executeGetRow('SELECT id, name, school_id, teacher_id, room_name, tutorial, max_users FROM class WHERE id = :id', array(
            'id'    => $id
        ));
    }


    public function getByTeacher($teacher_id) {
        return $this->executeGetRow('SELECT id, name, school_id, teacher_id, room_name, tutorial, max_users FROM class WHERE teacher_id = :teacher_id', array(
            'teacher_id'    => $teacher_id
        ));
    }
}
