<?php

class Teacher extends BaseModel
{
    public function exists($id) {
        return $this->executeGetValue('SELECT id FROM teacher WHERE id = :id', array(
            'id'    => $id
        )) !== false;
    }


    public function emailToId($email) {
        return $this->executeGetValue('SELECT id FROM teacher WHERE email = :email', array(
            'email'    => $email
        ));
    }


    public function save($row) {
        $this->execute('
            INSERT INTO teacher
            SET
                id = :id,
                name = :name,
                surname = :surname,
                email = :email,
                school_id = :school_id
            ON DUPLICATE KEY UPDATE
                id = :id,
                name = :name,
                surname = :surname,
                email = :email,
                school_id = :school_id
        ', $row);

        return $row;
    }


    public function get($id) {
        return $this->executeGetRow('SELECT id, name, surname, email, school_id FROM teacher WHERE id = :id', array(
            'id'    => $id
        ));
    }


    public function delete($id) {
        //delete school
        $this->execute('DELETE FROM teacher WHERE id = :id', array(
            'id'    => $id
        ));

        //get classes
        $classes = array();
        foreach ($this->execute('SELECT id FROM class WHERE teacher_id = :teacher_id', array(
            'teacher_id'    => $id
        )) as $item)
            $classes[$item['id']] = null;

        $classes = array_keys($classes);

        if (!empty($classes)) {
            //delete students in classses
            $this->execute('DELETE FROM student WHERE class_id IN (' . implode(',', $classes) . ')');
        }

        //delete classes
        $this->execute('DELETE FROM class WHERE teacher_id = :teacher_id', array(
            'teacher_id'    => $id
        ));
    }
}
