<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
  "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">


<?php
    include_once getcwd() . '/../protected/config/global.php';
?>


<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
 <head>
    <title>api test</title>

    <script type="text/javascript" src="public/js/jquery-1.7.2.min.js"></script>
    <script type="text/javascript" src="public/js/jquery.md5.js"></script>

    <script>
        //api url
        apiUrl = window.location.href;

        testPos = apiUrl.lastIndexOf('/test');
        if (testPos != -1)
            apiUrl = apiUrl.substr(0, testPos) + '/api/';

        $(document).ready(function () {
            $('#testForm').submit(function() {
                $('#result').text('');

                //query
                try {
                    JSON.parse($('#data').val());
                } catch (e)
                {
                    //try to convert key=value&... string into object
                    var queryObj = {};

                    $('#data').val().replace(
                        new RegExp("([^?=&]+)(=([^&]*))?", "g"),
                        function($0, $1, $2, $3) { queryObj[$1] = $3; }
                    );

                    $('#data').val(JSON.stringify(queryObj));
                }

                //clean
                $('#api_token').val($.trim($('#api_token').val()));
                $('#api_version').val($.trim($('#api_version').val()));

                //generate token
                api_token = $('#method option:selected').text() + '<?php echo $config['api_token']; ?>';
                api_token = $.md5(api_token);

                $('#api_token').val(api_token);

                //version
                if ($('#api_version').val() == '')
                    $('#api_version').val('<?php echo $config['api_version']; ?>');
                
                $.ajax({
                    type: "POST",
                    url: apiUrl + $('#method option:selected').text(),
                    data: $(this).serialize(),
                    dataType: 'text'
                }).done(function(result) {
                    try
                    {
                        resultObj = JSON.parse(result);
                        $('#result').text(JSON.stringify(resultObj, null, '\t'));
                    }
                    catch(e)
                    {
                        //can be plain text
                        $('#result').text(result);
                    }
                });

                return false;
            });
        });
    </script>
 </head>

 <body>
     <div style="float: left; width: 20%">
        <h1>Send request</h1>
        <form action="#" method="POST" id="testForm">
            <p>method: </p>
            <select style="width: 300px;" id="method">
                <option>studentAdd</option>
                <option>studentDelete</option>
                <option>studentGet</option>
                <option>studentUpdate</option>
                <option>studentSave</option>
                <option>classAdd</option>
                <option>classDelete</option>
                <option>classGet</option>
                <option>classUpdate</option>
                <option>classSave</option>
                <option>schoolAdd</option>
                <option>schoolDelete</option>
                <option>schoolGet</option>
                <option>schoolUpdate</option>
                <option>schoolSave</option>
                <option>teacherAdd</option>
                <option>teacherDelete</option>
                <option>teacherGet</option>
                <option>teacherUpdate</option>
                <option>teacherSave</option>
            </select>

            <p>api_user:</p> <input style="width: 300px;" type="text" name="api_user"></input><br/>
            <p>api_token:</p> <input style="width: 300px;" type="text" name="api_token" id="api_token"></input><br/>
            <p>api_version:</p> <input style="width: 300px;" type="text" name="api_version" id="api_version"></input><br/>
            <p>data:</p> <textarea name="data" id="data" rows="20" style="width: 300px;"></textarea>

            <br/><br/>
            <input type="submit"></input>
        </form>
     </div>

     <div style="float: left">
         <h1>Response</h1>

         <pre id="result"></pre>
     </div>
 </body>

 <!--
- api_user - to jest użytkownik API, póki co dajemy "edufarma" - i tylko i wyłącznie ten użytkownik może korzystać w tej chwili z API
- api_token - na ten moment ustalamy md5(api_method+"edufarma.secret.key.839102!@#45%")
- api_version - pamiętaj, żeby to też mieć
- api_method - to idzię w URLu
- data - wiadomo
 -->
</html>
