<?php
/**
 * Provide school table CRUD functionality
 */
class RoomRepository extends PDORepository
{
  /**
   * @return room record
   */
  public function getAllRooms()
  {
    $q = $this->connection->prepare('SELECT 
        r.ID, 
        r.room_name, 
        s.school_name, 
        r.max_users 
      FROM rooms r
      LEFT JOIN schools s ON 
        s.ID = r.school_id
    ');
    $q->execute();
    return $q->fetchAll(PDO::FETCH_OBJ);
  } 
  
  /**
   * get room by id
   * @param int $id
   * @return array
   */
  public function getRoomById($id)
  {
    $q = $this->connection->prepare('SELECT 
        r.ID, 
        r.room_name, 
        r.school_id, 
        r.max_users 
      FROM rooms r
      WHERE r.ID = :id
    ');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    $q->execute();
    return $q->fetch(PDO::FETCH_ASSOC);
  }
  
  /**
   * 
   */
  public function saveRoom($id, $hash)
  {
  	$q = $this->connection->prepare('SELECT 1 FROM rooms WHERE room_name = :room_name AND school_id = :school_id');
  	$q->bindValue(':school_id', $hash['school_id'], PDO::PARAM_INT);
    $q->bindValue(':room_name', $hash['room_name'], PDO::PARAM_STR);
  	$q->execute();
  	
  	if($q->fetch())
  		return false;
  	
    if($id) return $this->updateRoom($id, $hash);
    return $this->insertRoom($hash);
  }
  protected function insertRoom($hash)
  {
    $q = $this->connection->prepare('INSERT INTO rooms SET school_id = :school_id, room_name = :room_name, max_users = :max_users');
    $q->bindValue(':school_id', $hash['school_id'], PDO::PARAM_INT);
    $q->bindValue(':room_name', $hash['room_name'], PDO::PARAM_STR);
    $q->bindValue(':max_users', $hash['max_users'], PDO::PARAM_INT);
    return $q->execute();
  }
  protected function updateRoom($id, $hash)
  {
    $q = $this->connection->prepare('UPDATE rooms SET school_id = :school_id, room_name = :room_name, max_users = :max_users WHERE ID = :id');
    $q->bindValue(':school_id', $hash['school_id'], PDO::PARAM_INT);
    $q->bindValue(':room_name', $hash['room_name'], PDO::PARAM_STR);
    $q->bindValue(':max_users', $hash['max_users'], PDO::PARAM_INT);
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }
  
  public function addNewRoom()
  {
     $q = $this->connection->prepare('INSERT INTO rooms(ID,room_name) VALUES(DEFAULT,"")');
     $q->execute();
     return $this->connection->lastInsertId();
  }
  
  public function removeRoomById($id)
  {
    $q = $this->connection->prepare('DELETE FROM rooms WHERE ID = :id');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }
}