<?php
/**
 * Provide school table CRUD functionality
 */
class UserRepository extends PDORepository
{
  /**
   * @return user record
   */
  public function getAllUsers()
  {
    $q = $this->connection->prepare('
      SELECT 
        u.ID, 
        u.username, 
        u.password, 
        u.room_id,
        r.room_name,
        s.ID as school_id,
        s.school_name
      FROM users u
      LEFT JOIN rooms r ON
        r.ID = u.room_id
      LEFT JOIN schools s ON
        s.ID = r.school_id
    ');
    if (!$q->execute()) print_r($q->errorInfo());
    
    return $q->fetchAll(PDO::FETCH_OBJ);
  } 
  
  /**
   * get user by id
   * @param int $id
   * @return array
   */
  public function getUserById($id)
  {
    $q = $this->connection->prepare('
      SELECT u.ID, u.username, u.password, u.room_id, r.school_id FROM users u 
      LEFT JOIN rooms r ON
      r.ID = u.room_id
      WHERE u.ID = :id
    ');
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    $q->execute();
    return $q->fetch(PDO::FETCH_ASSOC);
  }
  
  public function saveUser($id, $hash)
  {
  	
  	$q = $this->connection->prepare('SELECT 1 FROM users WHERE username = :username');
  	$q->bindValue(':username', $hash['username'], PDO::PARAM_STR);
  	$q->execute();
  	
  	if($q->fetch())
  		return false;
  		
  	
    $q = $this->connection->prepare('UPDATE users SET 
      username = :username,
      password = :password,
      room_id = :room_id WHERE ID = :id
    ');
    $q->bindValue(':username', $hash['username'], PDO::PARAM_STR);
    $q->bindValue(':password', $hash['password'], PDO::PARAM_STR);
    $q->bindValue(':room_id', $hash['room_id'], PDO::PARAM_INT);
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }

  public function removeUserById($id)
  {
    $q = $this->connection->prepare('
      DELETE FROM users WHERE ID =  :id
    ');    
    $q->bindValue(':id', $id, PDO::PARAM_INT);
    return $q->execute();
  }
}