<?php
if (!defined('SYSTEM_ROOT_DIR')) define('SYSTEM_ROOT_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);

class ApplicationException extends Exception {}

require_once SYSTEM_ROOT_DIR . 'Acl.php';
require_once SYSTEM_ROOT_DIR . 'Configuration.php';
require_once SYSTEM_ROOT_DIR . 'Enviroment.php';
require_once SYSTEM_ROOT_DIR . 'Profiler.php';
require_once SYSTEM_ROOT_DIR . 'Acl.php';
require_once SYSTEM_ROOT_DIR . 'acl/Role.php';
require_once SYSTEM_ROOT_DIR . 'Controller.php';
require_once SYSTEM_ROOT_DIR . 'EventDispatcher.php';

/**
 * Application class
 * 
 * @package system
 * @version 3.0.0 alpha
 * @author dawid kraczkowski <lunereaper>
 */
final class Application
{
    const APP_INIT_FORK = 'application_init';
    const VERSION = '3.0.2';

    private static $instance;
    private $enviroment;

    /**
     * Initialize application
     * 
     * @param string $configPath config path
     * @return Application
     */
    public static function init($_CONFIG)
    {   
        Profiler::initialize();
        Profiler::start(Application::APP_INIT_FORK, 'Application run overall');
        if (!self::$instance instanceof Application)
            self::$instance = new Application($_CONFIG);
        Profiler::stop(Application::APP_INIT_FORK);
        return self::$instance;
    }

    /**
     * Setup Enviroment for an Application
     * 
     */
    private function __construct($_CONFIG)
    {
        //set error handling & shutdown
        set_error_handler(array('Application', 'error'), E_ERROR & E_WARNING);
        register_shutdown_function(array('Application', 'shutdown'));
        $this->enviroment = new Enviroment($_CONFIG);
    }

    public function run()
    {
        try
        {
            $this->enviroment->run();
        }
        catch(Exception $e)
        {
            print_r($e);
        }        
    }

    public static function error($errorNo, $errorStr, $errorFile, $errorLine, $errorContext)
    {
        throw new ApplicationException($errorStr . ':' . $errorNo . ' in ' . $errorFile . ' at ' . $errorLine);
    }

    /**
     * Handle here debug info and so
     */
    public static function shutdown()
    {
       // print_r(Profiler::getLog());
       // print_r(Profiler::getStatus());
    }

    /**
     * Return application's enviroment
     */
    public static function getEnviroment()
    {
        return self::$instance->enviroment;
    }
}