<?php
require_once SYSTEM_ROOT_DIR . 'EventDispatcher.php';
require_once SYSTEM_ROOT_DIR . 'RepositoryLoader.php';
require_once SYSTEM_ROOT_DIR . 'PluginRegistry.php';
require_once SYSTEM_ROOT_DIR . 'View.php';

/**
 * Base Controller class
 */
abstract class Controller extends EventDispatcher
{
    protected $session;
    protected $className;
    
    public function __construct ()
    {
      //get class name
      $className = get_class($this);
      $this->className = $className;
      
      //register session
      $this->session  = Session::registerNamespace($className);

      //load plugins
      $controllerDir = APPLICATION_DIR . '/protected/controllers/' . strtolower($className);
      $this->controllerDir = $controllerDir;
      
      $this->view = new View($this);
    }
    abstract function index_page();
    abstract function getURIMethods();
    
    public function notFound()
    {
        
    }
    public function accessDenied()
    {
        
    }
    public function onLoad()
    {
        
    }
    protected function dispatchEvent($event)
    {
      PluginRegistry::run($event, $this);
      parent::dispatchEvent($event);
    }
    public function onUnload()
    {
        
    }
    
    public function validateUserName($userName)
    {
    	$pattern = '/^[a-zA-z0-9_\.]+$/';
    	return (bool)preg_match($pattern,$userName);
    }
}