<?php

require_once SYSTEM_ROOT_DIR . 'Session.php';
require_once SYSTEM_ROOT_DIR . 'session/SessionNamespace.php';
require_once SYSTEM_ROOT_DIR . 'Acl.php';
require_once SYSTEM_ROOT_DIR . 'Router.php';
require_once SYSTEM_ROOT_DIR . 'acl/Role.php';
require_once SYSTEM_ROOT_DIR . 'PluginRegistry.php';

/**
 * Enviroment class
 * 
 * @package system
 * @author dawid kraczkowski <lunereaper>
 */
class EnviromentException extends ApplicationException {}
class PermisionException extends EnviromentException {}
class Enviroment
{
    const SETTING_ENV_FORK_ID = 'enviroment_setup';
    private $isDebug;
    private $configuration;
    private $acl;
    private $hasAcl = false;
    private $router;
    private static $globalSessionNamespace;

    public function __construct($_CONFIG)
    {
        $this->configuration = new Configuration($_CONFIG);
    //print_r($this->configuration);
        if (!$this->configuration->application['session-namespace'])
        {
            throw new EnviromentException('session-namespace must be defined in configuration file');
        }
        
        if (!$this->configuration->application['application-namespace'])
        {
            throw new EnviromentException('application-namespace must be defined in configuration file');
        }
        
        //define application constans
        define('APPLICATION_NAMESPACE', $this->configuration->application['application-namespace']);
        define('APPLICATION_DIR', realpath($this->configuration->application['application-dir'])); 
        define('SESSION_NAMESPACE', $this->configuration->application['session-namespace']);
        define('BASE_HREF', $this->configuration->application['base-href']);
        //setup session
        Session::start();
        self::$globalSessionNamespace = Session::registerNamespace('_GLOBAL_');
        
        //setup enviroment
        if ($this->configuration->application['debug-mode'])
        {
            $this->setDebugEnviroment();
        }
        else
        {
            $this->setProductionEnviroment();
        }
        
        if ($this->configuration->application['use-acl'])
        {
            $this->setupAcl();
        }
        
        $this->router = new Router($this->configuration->routes['route']);
        
        PluginRegistry::init();
    }
    
    public function run()
    {
        $route = $this->router->findRoute(); 
        
        $controller = $route['controller'];
        $controllerClassName = ucfirst($controller) . 'Controller';
        $defaultControllerClassName = ucfirst($route['default']['controller']) . 'Controller';
        $controllerClassFile = APPLICATION_DIR . '/protected/controllers/' . strtolower($controller) . '.php';
        $defaultControllerClassFile =  APPLICATION_DIR . '/protected/controllers/' . strtolower($route['default']['controller']) . '.php';
        
  
        $action = $route['action'];
        key_exists('params', $route) ? $params = $route['params'] : $params = array();
        
        if (!is_readable($controllerClassFile))
        {
            $controllerClassFile = $defaultControllerClassFile;
            $controllerClassName = $defaultControllerClassName;
            $action = $route['default']['action'];
            if (!is_readable($controllerClassFile)) throw new EnviromentException('Controller file "' . $controllerClassFile . '" does not exists');
        }
        
        require_once $controllerClassFile;
        
        if (!class_exists($controllerClassName))
        {
            throw new EnviromentException('Controller class "' . $controllerClassName .'" does not exists');
        }
       
        //get connection and init repository-loader
        if ($this->configuration->db)
        {
            $connections = array_keys($this->configuration->db);
            $connection = $this->configuration->db[$connections[0]];
            RepositoryLoader::init($connection['dsn'], $connection['user'], $connection['password']);
        }
        
        if ($this->hasAcl && $this->acl->hasAccess($controller))
        {
            $runningController = new $controllerClassName();
            $runningController->onLoad();
        }
        else
        {
            $this->reloadEnviroment();
            throw new PermisionException('No access allowed');
        }
        
        $action == '*' ? $action = 'index_page' : false;
        if (!$action || $action == 'index_page')
        {   
            call_user_func_array(array($runningController, 'index_page'), $params);
        }
        else
        {
            if ($this->acl->hasAccess($controller, $action))
            {
                if(in_array($action, $runningController->getURIMethods()))
                {
                    call_user_func_array(array($runningController, $action), $params);
                }
                else
                {
                    call_user_func_array(array($runningController, 'notFound'), $params);
                }
            }
            else
            {
                call_user_func_array(array($runningController, 'accessDenied'), $params);
            }
        }
        $runningController->onUnLoad();
    }

    protected function setDebugEnviroment ()
    {
        $this->isDebug = true;
        ini_set('display_errors', true);
        error_reporting(E_ALL & ~E_NOTICE);
    }
    
    public function setupAcl ()
    {
        $this->hasAcl = true;
        if (!(self::$globalSessionNamespace->acl instanceof Acl))
            self::$globalSessionNamespace->acl = new Acl($this->configuration->acl);
        $this->acl = &self::$globalSessionNamespace->acl;
    }

    protected function setProductionEnviroment ()
    {
        ini_set('display_errors', false);
        $this->isDebug = false;
    }

    public function isDebug ()
    {
        return $this->isDebug;
    }

    public static function getGlobalSessionNamespace ()
    {
        return self::$globalSessionNamespace;
    }
    
    public function reloadEnviroment ()
    {
        self::$globalSessionNamespace->acl = new Acl($this->configuration->acl);  
    }
    
    public function hasAcl ()
    {
        return $this->hasAcl;
    }
}