<?php
/**
 * EventDispacher class
 * Observer
 * @package system
 */
abstract class EventDispatcher
{
  /**
   * @param array
   */
  protected $eventListeners;
  
  /**
   * Add Event Listener
   *
   * @param string $event
   * @param function $listener
   * @throws Exception
   */
  public function addEventListener($event,$listener)
  {
    if(is_array($listener))
    {
      if(is_object($listener[0]))
      {
        if(method_exists($listener[0],$listener[1]))
        {
          $this->eventListeners[$event][] = array(
            'object'  => $listener[0],
            'class'    => get_class($listener[0]),
            'method'   => $listener[1]
          );

        }
        else 
        {
          throw new Exception("Instance of ".get_class($listener[0])." does not have a public method: ".$listener[1]);
        }
      }
      else 
      {
        throw new Exception(var_dump($listener[0]." is not an object!"));
      }
      
    }
    else 
    {
      if(function_exists($listener))
      {
        $this->eventListeners[$event][] = array(
                  "object"  => NULL,
                    "function"  => $listener
                 );
      }
      else 
      {
        throw new Exception("Function ".$listener." does not exists");
      }
    }
  }
  
  /**
   * Remove event listener
   *
   * @param string $event
   * @param function $listener
   * @return boolean
   */
  public function removeEventListener($event,$listener)
  {
    if(!count($this->eventListeners)) return false;
    
    //remove listener if it is an object and has proper method
    if(is_array($listener) && is_object($listener[0]) && method_exists($listener[0],$listener[1]))
    {
      $class = get_class($listener[0]);
      foreach($this->eventListeners[$event] as &$l)
      {
        if($l['class'] == $class && $l['method'] == $listener[1]) unset($l);
      }
    }
    elseif(function_exists($listener))
    {
      foreach($this->eventListeners[$event] as &$l)
      {
        if($l['function'] == $listener) unset($l);
      }
    }
    else 
    {
      throw new Exception("Given listener is not a proper function or method of given object!");
    }
  }
  
  /**
   * Check if given object has event listener
   *
   * @param string $event
   * @param function $listener
   * @return boolean
   */
  public function hasEventListener($event,$listener)
  {
    if(!count($this->eventListeners)) return false;
    
    //remove listener if its an object and has proper method
    if(is_array($listener) && is_object($listener[0]) && method_exists($listener[0],$listener[1]))
    {
      $class = get_class($listener[0]);
      foreach($this->eventListeners[$event] as &$l)
      {
        if($l['class'] == $class && $l['method'] == $listener[1]) return true;
      }
    }
    elseif(function_exists($listener))
    {
      foreach($this->eventListeners[$event] as &$l)
      {
        if($l['function'] == $listener) return true;
      }
    }
    return false;
  }
  
  /**
   * Dispatch event
   *
   * @param string $event
   */
  protected function dispatchEvent($event)
  {
    if(!count($this->eventListeners[$event])) return null;
    
    foreach($this->eventListeners[$event] as $call)
    {
      if(is_object($call['object'])) $call['object']->{$call['method']}($this);  
      else call_user_func($call['function'], $this);
    }
  }
}
