<?php

require_once SYSTEM_ROOT_DIR . '/repository/PDORepository.php';
class RepositoryLoaderException extends Exception {}
/**
 * Loads repositories from application folder 
 */
class RepositoryLoader
{
  /**
   * Pass connection info and build up repository loader
   */
  public static function init($dsn, $user, $password)
  {
    try
    {
        self::$connection = new PDO($dsn, $user, $password, array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES \'UTF8\''));
        self::$isInit = true;
    } 
    catch (Exception $e) 
    {
        throw new RepositoryLoaderException('Wrong database configuration');
    }
  }
  
  /**
   * Gets repository
   * @param string $name repo name
   */
  public static function get($name)
  {
    if (key_exists($name, self::$loadedRepositories))
    {
        return self::$loadedRepositories[$name];
    }
    self::load($name);
    return self::$loadedRepositories[$name];   
  }
  
  /**
   * Loads repository
   * @param string $name reponame
   */
  public static function load($name)
  {
    if (!self::$isInit) throw new RepositoryLoaderException('No connection defined, define PDO connection in config file');
    $filename = APPLICATION_DIR . '/protected/repositories/' . ucfirst($name) . '.php';
    $classname = ucfirst($name) . 'Repository';
    
    require_once $filename;
    self::$loadedRepositories[$name] = new $classname(self::$connection);
  }
  
  private static $connection;
  private static $isInit = false;
  private static $loadedRepositories = array();
}