<?php

/**
 * Provide url routing 
 *
 * @todo: cache routes
 */
class Router
{
  public function __construct ($routes)
  {
    $this->requestURI = explode('?', $_SERVER['REQUEST_URI']);
    
    $this->requestURI = substr($this->requestURI[0],1); //ommit '/' character
    
    //drop slashed stuff
    $href = preg_replace('#http://[a-z0-9-\.]+/#is', '', BASE_HREF);
    
    $this->requestURI = str_replace($href, '', $this->requestURI);

    $this->routes = $this->parseRoutes($routes);
  }

  /**
   * Find current route regex
   * @return array route
   */
  public function findRoute ()
  {
    foreach ($this->routes as $route)
    {
      if (preg_match('#^' . $route['regex'] . '$#is', $this->requestURI, $matches) ||
          preg_match('#^' . $route['regex'] . '\/$#is', $this->requestURI, $matches))
      {
        array_shift($matches);
        $matchesLength = count($matches);
        for ($i = 0; $i < $matchesLength; $i++)
        {
          $name = $route['param_names'][$i];
          if ($name == 'controller') 
          {
              $route['controller'] = $matches[$i];
          }
          elseif ($name == 'action')
          {
              $route['action'] = $matches[$i]; 
          }
          else
          {
             $route['params'][$name] = $matches[$i]; 
          }
        } 
        unset($route['param_names']);
        return $route;
      }
    }
  }

  /**
   * Parse ini routes
   * @param array $routes
   */
  private function parseRoutes ($routes)
  {
    $i = 0;
    foreach ($routes as $route => $call)
    {
      $call = explode(':', $call);
      if (count($call) == 1)
        $call[1] = '*';
      $parsedRoutes[$i]['raw_route'] = $route;
      $routeParts = explode('/',$route);
      
      $parsedRoutes[$i]['controller'] = $call[0];
      $parsedRoutes[$i]['action']     = $call[1];
      $parsedRoutes[$i]['default']    = array('controller' => $call[0], 'action' => $call[1]);
      
      $routeLength = count($routeParts);
      for ($r = 0; $r < $routeLength; $r++)
      {
        $part = $routeParts[$r];
        if (substr($part, 0, 2) == '{$')
        {
          $pos = strpos($part, '}');
          $part = substr($part, 2, $pos - 2);
          $part = explode(':', $part);
          $parsedRoutes[$i]['param_names'][] = $part[0];
          $parsedRoutes[$i]['regex'] .= '(' . $part[1] . ')' . 
          str_replace(
            array('.','?','*','(',')','[',']','#'), 
            array('\.','\?','\*','\(','\)','\[','\]','\#'), 
            substr($routeParts[$r], $pos + 1)
          );
        }
        else
        {
          $parsedRoutes[$i]['regex'] .= $part;
        }
        if($routeLength - 1 > $r)
          $parsedRoutes[$i]['regex'] .= '\\/';
      }
      ++$i;
    }
    return $parsedRoutes;
  }
    
  private $routes;
  protected $requestURI;
    
}