<?php

/**
 * View class
 * Provide base template system
 */
class ViewException extends Exception {}
class ViewTemplateFileNotFound extends ViewException {}
class View
{
  public function __construct(Controller $controller)
  {
      $this->controller = $controller;
  }
  
  /**
   * apply template file
   * @param string $filename template file
   * @param array $data template data
   * @echos template 
   */
  public function apply($filename, $data = array())
  {
    $filename = APPLICATION_DIR . '/protected/views/' . $filename;
    if (!is_readable($filename))
    {
       throw new ViewTemplateFileNotFound('Template file ' . $filename . ' not found');
    }
    
    //define view vars
    $GLOBALS['__view_data__'] = &$data;
    foreach ($data as $varName => &$value)
    {
        ${$varName} = &$value;
    }
    
    ob_start();
    include $filename;
    $tpl = ob_get_contents();
    ob_end_clean();
    
    if (isset($GLOBALS['__tpl_begin_parent']))
    {
      foreach($GLOBALS['__tpl_begin_parent'] as $tplCnt)
      {
          echo $tplCnt;
      }
    }
    echo $tpl;
    
    //reverse ob
    if (isset($GLOBALS['__tpl_end_parent']))
    {
      $GLOBALS['__tpl_end_parent'] = array_reverse($GLOBALS['__tpl_end_parent']);
      foreach($GLOBALS['__tpl_end_parent'] as $tplCnt)
      {
          echo $tplCnt;
      }
    }
      
  }
}


/**
 * Imports template
 */
function view_import($filename)
{
  //import view vars
  $data = &$GLOBALS['__view_data__'];
  foreach ($data as $varName => &$value)
  {
    ${$varName} = &$value;
  }
  if (is_readable($filename))
  {
      include $filename;
  }
}
/**
 * Dispatch event in template file
 * @param string $event
 */
function view_dispatch($event)
{
  PluginRegistry::run($event, $GLOBALS['__view_data__']);
}
/**
 * Extends template file
 * @param string $filename tempalte file path
 */
function view_extend($filename)
{
  
  ob_start();
  view_import($filename);
  
  $GLOBALS['__tpl_end_parent'][] = ob_get_contents();
  ob_end_clean();
}
/**
 * Create extend slot in template file
 */
function view_extend_slot()
{
  $GLOBALS['__tpl_begin_parent'][] = ob_get_contents();
  ob_clean();
}
