<?php

class RoleException extends Exception { }

class Role
{
    public $roleName;
    
    protected $restrictions;
    
    public function __construct ($roleName)
    {
        $this->roleName = $roleName;
        
        //default access to all = false
        $this->restrictions['*'] = 0;
    }
    
    public function addRestriction ()
    {
        $args = func_get_args();
        switch($args[0])
        {
            case 'allow':
                $allow = 1;
                break;
            case 'deny':
            default:
                $allow = 0;
                break;
        }
        array_shift($args);
        $argsLength = count($args);
        if (!$argsLength) 
            throw new RoleException ('No restrictions defined in ' . __CLASS__ . '::' . __FUNCTION__ . '()');
        if ($argsLength > 1)
        {
            $this->restrictions[$args[0]][$args[1]] = $allow;
            return $access;
        }
        if ($args[0] === '*') 
            $this->restrictions[$args[0]] = $allow;
        else
            $this->restrictions[$args[0]]['*'] = $allow;
    }
    
    /**
     * Check if role has access to given resource
     * @param string $resource resource name
     * @param string $action action name
     * @return int(0/1)
     */
    public function hasAccess ($resourcePoll, $resource = null)
    {
        $access = $this->restrictions['*'];
        
        //if restriction for resource exists
        if (key_exists($resourcePoll, $this->restrictions)) 
            $access = $this->restrictions[$resourcePoll]['*'];
        else
            return $access;
        
        //if action in resource is defined
        if ($action && key_exists($resource, $this->restrictions[$resourcePoll]))
            $access = $this->restrictions[$resourcePoll][$resource];
        
        return $access;
    }
}