<?php

/**
 * SessionNamespace class
 * 
 * @package system\session
 * @author dawid kraczkowski <lunereaper>
 */
class SessionNamespace
{
  /**
   * Session vars
   * @param array
   */ 
  protected $vars;
  
  /**
   * Expiration time
   * @param int
   */
  protected $expirationTime;
  
  /**
   * Namespace expire at
   * @param int
   */
  protected $expireAt;
  
  /**
   * Set expiration time
   * @param int $seconds
   * @return int namespace expiration
   */
  public function setExpirationTime($seconds = 0)
  {
    $this->expirationTime = $seconds;
    $this->expirationTime ? $this->expireAt = time() + $this->expirationTime : null;
    return $this->expireAt;
  }
  
  /**
   * Get session variable
   * @param string $name
   */
  public function __get($name)
  {
    if(!$this->expireAt) return $this->vars[$name];
    if($this->expireAt && time() < $this->expireAt)
    {
      $this->expireAt = time() + $this->expirationTime;
      return $this->vars[$name];
    }
    return $this->vars = null;
  }
  
  /**
   * Set new session variabe
   * @param string $name
   * @param mixed $value
   */
  public function __set($name, $value)
  {
    $this->expireAt ? $this->expireAt = time() + $this->expirationTime : null;
    $this->vars[$name] = $value; 
  }
  
  /**
   * Refresh session expire at
   * @return int namespace expiration
   */
  public function renew()
  {
    $this->expireAt ? $this->expireAt = time() + $this->expirationTime : null;
    return $this->expireAt;
  }
  
  /**
   * Get expiration time
   * @return int expiration time
   */
  public function getExpirationTime()
  {
    return $this->expireTime;
  }
  
  /**
   * Get namespace expiration
   * @return int namespace expiration
   */
  public function expireAt()
  {
    return $this->expireAt;
  }
}
