/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/
var paramsObject
var processCount
var interval
var dbase;
var terminate = false;

function init()
{
	//trace("Extension initialized")
	
	paramsObject = new Object();
	processCount = 0;
	interval = 0;
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{	
	// Get a reference to the Zone where the target extension is running
	var zone = _server.instance.getZone("eduFarma");

	// Get a reference to the Extension we want to call
	var targetExtension = zone.getExtension("databaseExt");
	
	var sql = "";
	var queryRes;
	var response = {}
	
	//trace(cmd)
		
	if (cmd == "setBuildingData")
	{		
		sql = "INSERT INTO user_has_buildings (type_id, x, y, level, owner, upgrade_progress) VALUES ("
		sql += "'" + _server.escapeQuotes(params.typeId) + "', "
        sql += "'" + _server.escapeQuotes(params.x) + "', "
        sql += "'" + _server.escapeQuotes(params.y) + "', "
        sql += "'" + _server.escapeQuotes(params.level) + "', "
        sql += "'" + _server.escapeQuotes(params.userId) + "', "
        sql += "1)"
		
		dbase.executeCommand(sql); 
		
		sql = "SELECT LAST_INSERT_ID() AS id FROM user_has_buildings"
		
		queryRes = dbase.executeQuery(sql);
		
		response._cmd = cmd;
						
		var tempRow = queryRes.get(0);
		response.db = tempRow.getItem("id");
	}
	else if (cmd == "deleteBuildingData")
	{
		sql = "DELETE FROM user_has_buildings WHERE ID = " + params.dbId + " AND owner = " + params.userId;
		dbase.executeCommand(sql);
		
		sql = "DELETE FROM products_in_progress WHERE building_id = " + params.dbId + " AND owner = " + params.userId;
		dbase.executeCommand(sql);
	}
	else if (cmd == "deleteWarehouseData")
	{
		sql = "DELETE FROM user_has_buildings WHERE ID = " + params.dbId + " AND owner = " + params.userId;
		dbase.executeCommand(sql);
	}
	else if (cmd == "updateBuildingData")
	{
		var sql;
			
		sql = "UPDATE user_has_buildings SET x = "
		sql += "'" + _server.escapeQuotes(params.x) + "', "
		sql += "y = '" + _server.escapeQuotes(params.y) + "' "
		sql += " WHERE ID = " + params.dbId;
		sql += " AND owner = " + params.userId;
	
		dbase.executeCommand(sql);
	}
	else if (cmd == "nullProgress")
	{
		var sql;
			
		sql = "UPDATE user_has_buildings SET upgrade_progress = 0 "
		sql += " WHERE ID = " + params.dbId;
		sql += " AND owner = " + params.userId;
	
		dbase.executeCommand(sql);
	}
	else if (cmd == "updateBuildingProduct")
	{
		var sql;					
		sql = "DELETE FROM products_in_progress WHERE building_id = " + params.dbId + " AND owner = " + params.userId;	
		dbase.executeCommand(sql);
	}
	else if (cmd == "terminateProcess")
	{
		terminate = true;
	}
	else if (cmd == "upgradeBuilding")
	{
		//trace(params.structureID + " " + params.newLevel + " " + params.totalTime);
	
		params.processLength = params.totalTime;
		
		if (paramsObject["values"] == null || paramsObject["values"] == undefined) paramsObject["values"] = [];
		paramsObject["values"].push(params);
		processCount++;
		
		if(interval == 0) interval = (setInterval("processUpdate", 1000));
	}
		
	response.structureId = params.structureId;
	response._cmd = cmd;
	_server.sendResponse(response, -1, null, [user])
}

function processUpdate()
{
	for (i = 0; i < processCount; i++)
	{
		paramsObject["values"][i].totalTime--;
		
		if (paramsObject["values"][i].totalTime == 0 || terminate)
		{			
			var sql;
			
			if (!terminate)
			{
				sql = "UPDATE user_has_buildings SET level = "
				sql += "'" + _server.escapeQuotes(paramsObject["values"][i].newLevel) + "', "
				sql += " upgrade_progress = 0"
				sql += " WHERE ID = " + paramsObject["values"][i].dbId + " AND owner = " + paramsObject["values"][i].userId;
			}
			else
			{
				sql = "UPDATE user_has_buildings SET upgrade_progress = "
				sql += "'" + _server.escapeQuotes(Math.round((parseInt(paramsObject["values"][i].totalTime)/parseInt(paramsObject["values"][i].processLength))*100)) + "' "
				sql += " WHERE ID = " + paramsObject["values"][i].dbId + " AND owner = " + paramsObject["values"][i].userId;
			}
		
			dbase.executeCommand(sql);
			
			paramsObject["values"].splice(i, 1);
			processCount--;
		}
	}
	
	if (processCount == 0)
	{
		clearInterval(interval);
		interval = 0;
		paramsObject["values"] = null;
	}
}


function handleInternalRequest(evt)
{
	if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
}

/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}