/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/
var dbase;
var globalUser;

function init()
{
	//trace("Extension initialized")
}


/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{
	globalUser = user;
		
	var sql = "";
	var queryRes;
	
	//trace(cmd)
	
	if (cmd == "getCash")
	{
		sql = "SELECT cash FROM student WHERE id = " + params.userId;
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow = queryRes.get(0);
			var cash = tempRow.getItem("cash");
			
			var response = { };
			response._cmd = cmd;
			response.cash = cash;
			
			_server.sendResponse(response, -1, null, [user])
		}
	}
	else if (cmd == "getLoan")
	{
		sql = "SELECT loan, loan_rate, loan_length FROM student WHERE id = " + params.userId;
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow = queryRes.get(0);
			var loan = tempRow.getItem("loan");
			var loanRate = tempRow.getItem("loan_rate");
			var loanLength = tempRow.getItem("loan_lenght");
			
			var response = { };
			response._cmd = cmd;
			response.loan = loan;
			response.loanRate = loanRate;
			response.loanLength = loanLength;
			
			_server.sendResponse(response, -1, null, [user])
		}
	}
	else if (cmd == "updateCash")
	{
		sql = "UPDATE student SET cash = " + params.cash + " WHERE id = " + params.userId;
		
		dbase.executeCommand(sql);
		
		sendSyncData(params.userId);
	}
	else if (cmd == "updateLoan")
	{
		var sql;
			
		sql = "UPDATE student SET loan = "
		sql += "'" + _server.escapeQuotes(params.loan) + "', "
		sql += "loan_rate = '" + _server.escapeQuotes(params.loanRate) + "', "
		sql += "loan_length = '" + _server.escapeQuotes(params.loanLength) + "' "
		sql += " WHERE id = " + params.userId;
	
		dbase.executeCommand(sql);
	}
}

function handleInternalRequest(evt)
{
	if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
	
	if(evt.cmd == "syncCash")
	{
		//trace("Internal request: syncCash")
	
		sendSyncData(evt.userId)
	
		/*trace("Internal request: syncCash, for user: evt.userId")
		
		sql = "SELECT cash-loan AS cash FROM student WHERE id = = " + evt.userId;
		queryRes = dbase.executeCommand(sql);
		
		if (queryRes && queryRes.size() > 0)
		{ 
			var tempRow = queryRes.get(0);
			var cash = tempRow.getItem("cash");
		
			trace("Current user cash is: "+cash);
		}*/
	}
}

function sendSyncData(userId)
{
	//trace("Internal request: syncCash, for user: "+userId)
		
		sql = "SELECT cash-loan AS cash FROM student WHERE id =" + userId;
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow = queryRes.get(0);
			var cash = tempRow.getItem("cash");
		
			//trace("Current user cash is: "+cash);
			sendToAPI(cash,userId);
			/*
			APIPage.aspx?apiname=savemoney&id=120&money=57&check=011725bb021b57e9a3e8d9239758bf43
			
			id=XXX&money=YYY&check=MD5

			XXX = (id + 19) * 6
			YYY = (money + 14) * 3
			MD5 = MD5(id.ToString() + "_" + money.ToString()) - liczymy MD5 z takiego ciagu: id_money przed modyfikacja matematyczna
			Money jest liczba typu float - obcinamy ja aby uzyskac dwa miejsca po przecinku i separatorem dziesietnym jest kropka, czyli:
			12.01 albo 123.32 albo 120.00 albo 0.00
			
			*/
		}
}

function sendToAPI(cash,user)
{
		var send = new LoadVars();
		var load = new LoadVars();
		
		send.status = "1";
		
		load.onLoad = function(success, errorMsg)
	    {
		    if (success)
		    {
				//trace("Data send to API.")
			}
			else
			{
				//trace("Loadvar Failed. " + errorMsg)
			}
	    }
		
		var x = (parseInt(user)+19) * 6;
		var y = (parseInt(cash)+14) * 3;
		
		//trace("x="+x);
		//trace("y="+y);
		//trace("md5 source="+user+"_"+cash);
		
		var check = _server.md5(user+"_"+cash);
		var url = "http://edukariera.inisoft.pl/APIPage.aspx?apiname=savemoney&id="+x+"&money="+y+"&check="+check;
		
		//trace("Send request to URL:"+url);
		
		send.sendAndLoad(url, load, "GET");
}

/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	// Add your code here
}