/* 
* Initializion point:
* 
* this function is called as soon as the extension
* is loaded in the server.
* 
* You can add here all the initialization code
* 
*/

var dbase;
var userList
var finishedUsers;
var intervals;
var _roundTime = 600/2;

function init()
{
	userList = [];
	finishedUsers = [];
	intervals = [];
	
	//trace("Extension initialized")	
}

/*
* This method is called by the server when an extension
* is being removed / destroyed.
* 
* Always make sure to release resources like setInterval(s)
* open files etc in this method.
* 
* In this case we delete the reference to the databaseManager
*/
function destroy()
{
	//trace("Extension destroyed")
	delete dbase;
	
	for (var i = 0; i < intervals.length; i++)
	{
		clearInterval(intervals[i].interval);
	}
	
	intervals = null;
}


/*
* 
* Handle Client Requests
* 
* cmd 		= a string with the client command to execute 
* params 	= list of parameters expected from the client
* user 		= the User object representing the sender
* fromRoom 	= the id of the room where the request was generated
* 
*/
function handleRequest(cmd, params, user, fromRoom)
{
	var sql;
	var queryRes;
	var response;
	
	//trace("Handler: "+cmd);
	
	//trace(cmd);
	if (cmd == "authenticate")
	{
		var sessionId = params.sessionId;
		var userId = params.userId;
		
		//trace("outh user1")
		
		var send = new LoadVars();
		var load = new LoadVars();
		
		//trace("sid: "+sessionId+", User:"+userId);
		
		load.onLoad = function(success, errorMsg)
	    {
		    if (success)
		    {
				response = { };
				response._cmd = cmd;				
				
				response.authenticationStatus = String(load["success"]);
				
				if(String(response.authenticationStatus) == "1")
				{
					var sql = "SELECT name, class_id, accepted FROM student WHERE id = " 
					sql += "'" + String(userId) + "'"
				
					queryRes = dbase.executeQuery(sql);
				
					var accepted = 0;
					var roomId = -1;
					var roomName = "";
		
					if (queryRes && queryRes.size() > 0)
					{
						var tempRow = queryRes.get(0)
            					
						accepted = parseInt(tempRow.getItem("accepted"));
						accepted = 1;
						roomId = parseInt(tempRow.getItem("class_id"));
					
						var sql = "SELECT room_name, school_id FROM class WHERE id = ";
						sql += _server.escapeQuotes(roomId);
					
						queryRes = dbase.executeQuery(sql);
					
						if (queryRes && queryRes.size() > 0)
						{
							var tempRow = queryRes.get(0)
									
							roomName = String(tempRow.getItem("school_id") + "_" + tempRow.getItem("room_name"));
						}					
					}
		
					response.roomName = roomName;
					response.roomId = roomId;
				
					_server.sendResponse(response, -1, null, [user]);
				}
				
				//trace("Success flag: "+response.authenticationStatus);
			}
			else
			{
				//trace("Loadvar Failed. " + errorMsg)
			}
	    }
		
		var apiURL = "http://edukariera.inisoft.pl/APIPage.aspx?apiname=checksession&id="+userId+"&sessionuid="+sessionId;
		//trace("URL to hit:"+apiURL);
		send.sendAndLoad(apiURL, load, "POST");	
	}
	if (cmd == "authenticateTeacher")
	{
		var sessionId = params.sessionId;
		var userId = params.userId;
		
		//trace("Teacher: "+userId+", sid:"+userId);
		
		var send = new LoadVars();
		var load = new LoadVars();
		
		load.onLoad = function(success, errorMsg)
	    {
		    if (success)
		    {
				response = { };
				response._cmd = cmd;				
				
				response.authenticationStatus = String(load["success"]);
				
				var sql = "SELECT id,name, school_id FROM teacher WHERE id = " 
				sql += "'" + String(userId) + "'"
								
				queryRes = dbase.executeQuery(sql);
				
				var accepted = 0;
				var roomId = -1;
				var roomName = "";
				var schoolId = -1;
		
				if (queryRes && queryRes.size() > 0)
				{
					var tempRow = queryRes.get(0)
            					
					//accepted = parseInt(tempRow.getItem("accepted"));
					teacherId = parseInt(tempRow.getItem("id"));
					schoolId = parseInt(tempRow.getItem("school_id"));
					
					var sql = "SELECT id,room_name, school_id FROM class WHERE teacher_id = ";
					sql += _server.escapeQuotes(teacherId);
					
					queryRes = dbase.executeQuery(sql);
					
					if (queryRes && queryRes.size() > 0)
					{
						var tempRow = queryRes.get(0)
									
						roomName = String(tempRow.getItem("school_id") + "_" + tempRow.getItem("room_name"));
						roomId = tempRow.getItem("id");
					}					
				}
		
				response.roomName = roomName;
				response.roomId = roomId;
				response.schoolId = schoolId;
				
				_server.sendResponse(response, -1, null, [user]);
			}
			else
			{
				trace("Loadvar Failed. " + errorMsg)
			}
	    }
		
		var apiURL = "http://edukariera.inisoft.pl/APIPage.aspx?apiname=checksession&id="+userId+"&sessionuid="+sessionId;
		send.sendAndLoad(apiURL, load, "POST");	
	}
	else if (cmd == "userRegistration")
	{
		/*sql = "SELECT * FROM users WHERE username = '" + _server.escapeQuotes(params.username) + "'";
		
		queryRes = dbase.executeQuery(sql);
		response = {};
				
		if (queryRes == null || queryRes == undefined || queryRes.size() == 0)
		{
			sql = "INSERT INTO users (username, password, cash, field_size_x, field_size_y) VALUES("
			sql += "'" + _server.escapeQuotes(params.username) + "', "
			sql += "'" + _server.escapeQuotes(params.password) + "', "
			sql += "'" + _server.escapeQuotes(params.cash) + "', "
			sql += "'" + _server.escapeQuotes(params.fieldX) + "', "
			sql += "'" + _server.escapeQuotes(params.fieldY) + "')"
			
			//trace(sql);
			
			queryRes = dbase.executeCommand(sql);
			
			if (queryRes)
			{
				sql = "SELECT ID FROM users WHERE username = '" + _server.escapeQuotes(params.username) + "'";
				
				queryRes = dbase.executeQuery(sql);		
							
				if (queryRes)
				{
					var tempRow = queryRes.get(0);
					var userId = tempRow.getItem("ID");
					
					response._cmd = cmd;
					response.success = queryRes;
					response.dbId = userId;

					_server.sendResponse(response, -1, null, [user])
				}
				
				_server.logoutUser(user);
			}						
			
		}
		else
		{
			response._cmd = cmd;
			response.success = false;

			_server.sendResponse(response, -1, null, [user])
		}*/
	}
	else if (cmd == "teacherRegistration")
	{
		/*sql = "SELECT * FROM teachers WHERE username = '" + _server.escapeQuotes(params.username) + "'";
		
		//trace(sql);
		queryRes = dbase.executeQuery(sql);
		response = {};
				
		if (queryRes == null || queryRes == undefined || queryRes.size() == 0)
		{
			sql = "INSERT INTO teachers (username, password, room_id) VALUES("
			sql += "'" + _server.escapeQuotes(params.username) + "', "
			sql += "'" + _server.escapeQuotes(params.password) + "', "
			sql += "0)"
			
			//trace(sql);
			
			queryRes = dbase.executeCommand(sql);
			
			if (queryRes)
			{
				sql = "SELECT ID FROM teachers WHERE username = '" + _server.escapeQuotes(params.username) + "'";
				
				queryRes = dbase.executeQuery(sql);
							
				if (queryRes)
				{
					var tempRow = queryRes.get(0);
					var userId = tempRow.getItem("ID");
					
					response._cmd = cmd;
					response.success = queryRes;
					response.dbId = userId;

					_server.sendResponse(response, -1, null, [user])
				}
				
				_server.logoutUser(user);
			}						
			
		}
		else
		{
			response._cmd = cmd;
			response.success = false;

			_server.sendResponse(response, -1, null, [user])
		}*/
	}
	else if (cmd == "expandGrid")
	{
		sql = "UPDATE student SET field_size_x = "
		sql += _server.escapeQuotes(params.fieldX) + ", field_size_y = "
		sql += _server.escapeQuotes(params.fieldY)
		sql += " WHERE id = " + _server.escapeQuotes(params.userId)
		
		//trace(sql);
		
		dbase.executeCommand(sql);
	}
	else if (cmd == "getWaitingUsers")
	{
		//trace("getWaitingUsers:"+sql);
	
		sql = "SELECT student.id, student.name, student.accepted, class.room_name, school.name FROM (student LEFT JOIN class ON student.class_id = class.id) LEFT JOIN school ON class.school_id = school.id WHERE student.class_id = " + _server.escapeQuotes(params.roomId);
		
		
		queryRes = dbase.executeQuery(sql, _server.QUERY_INT_KEYS);
		
		var usersToAccept = [];
			
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow;
			var limiter = userList.length;
			//trace(limiter);
			
			for (var i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				var id = tempRow.getItem(1);
				var nick = tempRow.getItem(2);				
				var accepted = tempRow.getItem(3);
				var className = tempRow.getItem(4);
				var schoolName = tempRow.getItem(5);				
				
				//trace(nick);							
				
				for (var j = 0; j < limiter; j++)
				{					
					if (String(id) == String(userList[j].getName().split("_")[1]))
					{
						//trace("MUAHAHA");
						
						var userObject = { };
						userObject.username = nick;
						userObject.id = id;
						userObject.accepted = accepted;
						userObject.schoolName = schoolName;
						userObject.className = className;
						userObject.serverId = userList[j].getUserId();
						
						usersToAccept.push(userObject);
						
						break;
					}
				}
			}			
		}
		
		response = { };
		response._cmd = cmd;
		response.users = usersToAccept;
		
		_server.sendResponse(response, -1, null, [user])
		
	}
	else if (cmd == "refuseUser")
	{
		var limiter = userList.length;
		
		for (var i = 0; i < limiter; i++)
		{
			if (String(userList[i].getName()) == String(params.username))
			{
				_server.disconnectUser(userList[i]);				
				
				response = { };
				response._cmd = cmd;
				response.message = "refused";
				
				_server.sendResponse(response, -1, null, [userList[i]])			
				
				break;
			}
		}
	}
	else if (cmd == "confirmUser")
	{
		sql = "UPDATE student SET accepted = 1 WHERE id = " + _server.escapeQuotes(params.id);
		
		dbase.executeCommand(sql);
	}
	else if (cmd == "getSchoolList")
	{
		sql = "SELECT id, name FROM school";
		
		//trace(sql);
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow;
			response = { };
			response._cmd = cmd;
			response.schools = [];
			
			for (var i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				response.schools.push( {id:tempRow.getItem("id"), schoolName:tempRow.getItem("name")});
			}
			
			_server.sendResponse(response, -1, null, [user])
		}
	}
	else if (cmd == "countdownSimulation")
	{
		var limiter = intervals.length;
		var newInterval = true;
		var intervalStart = 0;
		var roundId = -1;
		
		var zone = _server.instance.getZone("eduFarma");
		
		var room = zone.getRoom(fromRoom);
		
		sql = "SELECT tutorial FROM class WHERE room_name = '" + _server.escapeQuotes(room.getName().split("_")[1]) + "'";
	
		queryRes = dbase.executeQuery(sql);
		
		var tempRow = queryRes.get(0);
		var tutorial = parseInt(tempRow.getItem("tutorial"));
				
		if (tutorial == "1" || tutorial == 1)
		{
			//trace("TUTORIAL: " + tutorial);
			
			var recipientList = [];
			var limiter = userList.length;

			for (var i = 0; i < limiter; i++)
			{
				var rooms = userList[i].getRoomsConnected();
				
				for (var j = 0; j < rooms.length; j++)
				{
					if (rooms[j] == fromRoom)
					{
						recipientList.push(userList[i]);
						break;
					}
				}
			}
			
			var response = { };
			response.command = "timeSync";
			response.tutorial = 1;			
			response.time = _roundTime;
			response.targetTime = _roundTime;
			response._cmd = cmd;
			response.roundId = roundId;

			_server.sendResponse(response, fromRoom, null, recipientList);
			
			sql = "UPDATE class SET tutorial = 0 WHERE room_name = '" + _server.escapeQuotes(room.getName().split("_")[1]) + "' AND school_id = " + _server.escapeQuotes(room.getName().split("_")[0]);
		
			queryRes = dbase.executeCommand(sql);
		}
		else
		{
		
			for (var i = 0; i < limiter; i++)
			{
				if (intervals[i] && parseInt(intervals[i].roomId) == parseInt(fromRoom)) 
				{
					newInterval = false;
					intervalStart = intervals[i].intervalStart;
				}
			}
			
			if (newInterval)
			{		
				var index = -1;
				
				for (var i in intervals)
				{
					if (intervals[i] == null)
					{
						index = i;
						break;
					}
				}
				
				if (index < 0)
				{
					var intervalObject = { };
					intervalObject.interval = setInterval("startSimulation", _roundTime*1000, { intervalId:intervals.length } ); //600000
					intervalObject.roomId = fromRoom;
					intervalObject.roomName = room.getName();
					intervalObject.intervalStart = getTimer();
				
					intervals.push( intervalObject );
				}
				else
				{
					intervalObject = { };
					intervalObject.interval = setInterval("startSimulation", _roundTime*1000, { intervalId:index } ); //600000
					intervalObject.roomId = fromRoom;
					intervalObject.roomName = room.getName();
					intervalObject.intervalStart = getTimer();
				
					intervals[index] = intervalObject;
				}
				
				sql = "SELECT id FROM class WHERE room_name = '" + _server.escapeQuotes(room.getName().split("_")[1]) + "' AND school_id = " + _server.escapeQuotes(room.getName().split("_")[0]);
		
				queryRes = dbase.executeQuery(sql);
				
				var tempRow = queryRes.get(0);
				var dbRoomId = tempRow.getItem("id");
				
				//trace("DB ROOM ID: " + dbRoomId);
				
				sql = "SELECT ID, round_number FROM rounds WHERE room_id = " + dbRoomId + " LIMIT 1";
					
				queryRes = dbase.executeQuery(sql);
					
				if (value == "NULL" || value == null) roundNumber = 1;
				
				if (roundNumber == NaN) roundNumber = 1;
				var roundNumber;			
							
				if (queryRes && queryRes.size() == 0)
				{
					sql = "INSERT INTO rounds (round_number, room_id) VALUES (";
					sql += "1, ";
					sql += dbRoomId + ")";
					
					roundNumber = 1;			
				}
				else
				{
					tempRow = queryRes.get(0);
				
					var value = tempRow.getItem("round_number");
					
					//trace("ROUND NUMBER: " + value);
					
					roundNumber = parseInt(value) + 1;
					
					sql = "UPDATE rounds SET round_number = ";
					sql += roundNumber + " WHERE room_id = ";
					sql += dbRoomId;
					
					roundId = tempRow.getItem("ID")
				}					
				
				//trace("ROUND SQL: " + sql);
				
				queryRes = dbase.executeCommand(sql);
				
				if (roundNumber == 1)
				{
					sql = "SELECT LAST_INSERT_ID() AS id FROM rounds"
			
					queryRes = dbase.executeQuery(sql);
													
					tempRow = queryRes.get(0);
					roundId = tempRow.getItem("id");
				}
			}
			
			var recipientList = [];
			var limiter = userList.length;

			for (var i = 0; i < limiter; i++)
			{
				var rooms = userList[i].getRoomsConnected();
				
				for (var j = 0; j < rooms.length; j++)
				{
					if (rooms[j] == fromRoom)
					{
						recipientList.push(userList[i]);
						break;
					}
				}
			}		
			
			var response = { };
			response.command = "timeSync";
			
			if (newInterval) response.time = _roundTime;
			else response.time = parseInt(_roundTime - parseInt((getTimer() - parseInt(intervalStart)) / 1000));
			
			response.targetTime = _roundTime;
			response._cmd = cmd;
			response.roundId = roundId;

			_server.sendResponse(response, fromRoom, null, recipientList);
		}
	}
	else if (cmd == "endGame")
	{		
		if (parseInt(params.userId) < 0)
		{
			var zone = _server.instance.getZone("eduFarma");
		
			var room = zone.getRoom(fromRoom);
			
			sql = "SELECT id FROM class WHERE room_name = '" + _server.escapeQuotes(room.getName().split("_")[1]) + "' AND school_id = " + _server.escapeQuotes(room.getName().split("_")[0]);
		
			queryRes = dbase.executeQuery(sql);
			
			tempRow = queryRes.get(0);
			dbRoomId = tempRow.getItem("id");
			
			//trace("DB ROOM ID: " + dbRoomId);
			
			sql = "SELECT name, loan AS money FROM student WHERE class_id = " + dbRoomId;
			
			queryRes = dbase.executeQuery(sql);
			
			//trace("SQL: " + sql + ", " + parseInt(queryRes.size()));
			
			if (queryRes && queryRes.size() > 0)
			{
				limiter = queryRes.size();
				
				response = { };
				response.command = "endGameResults";
				response.results = [];
				
				var name;
				var score;
				var invalid = true;
				
				for (var i = 0; i < limiter; i++)
				{
					invalid = true
					tempRow = queryRes.get(i);
					name = tempRow.getItem("username");
					score = tempRow.getItem("money");
					
					for (var j = 0; j < userList.length; j++)
					{
						if (userList[j] != undefined && String(userList[j].getName()) == String(name))
						{
							invalid = false;
							break;
						}
					}
					
					if (invalid) continue;
					
					//trace("SCORE: " + String(name) + ", " + parseInt(score));
					response.results.push( { name:name, score:score } );
				}
				
				var recipientList = [];
				limiter = userList.length;

				for (var i = 0; i < limiter; i++)
				{
					var rooms = userList[i].getRoomsConnected();			
					
					for (var j = 0; j < rooms.length; j++)
					{
						if (rooms[j] == fromRoom)
						{
							recipientList.push(userList[i]);
							break;
						}
					}
				}				
				
				//trace("RECIPIENST: " + parseInt(recipientList.length));
				
				_server.sendResponse(response, fromRoom, null, recipientList);
			}
			
			var users = room.getAllUsers();
			
			var limiter = users.length;
			
			for (var i = 0; i < limiter; i++)
			{
				if(String(users[i].getName()).split("_")[0] != "teacher") _server.disconnectUser(users[i]);
			}
		}
		else
		{
			var limiter = userList.length;
			
			for (var i = 0; i < limiter; i++)
			{
				if (parseInt(params.userId) == parseInt(userList[i].getUserId()))
				{
					_server.disconnectUser(userList[i]);
					break;
				}
			}
		}
	}
	else if (cmd == "getRoomList")
	{
		sql = "SELECT id, room_name, name FROM class WHERE school_id = " + _server.escapeQuotes(params.selectedSchool) + " AND teacher_id = "  + _server.escapeQuotes(params.id);
		
		queryRes = dbase.executeQuery(sql);
		
		if (queryRes && queryRes.size() > 0)
		{
			var tempRow;
			response = { };
			response._cmd = cmd;
			response.rooms = [];
			
			var zone = _server.instance.getZone("eduFarma");
						
			for (var i = 0; i < queryRes.size(); i++)
			{
				tempRow = queryRes.get(i);
				
				var room = zone.getRoomByName(String(params.selectedSchool) + "_" + tempRow.getItem("room_name"));
				
				if (room != null)
				{
					response.rooms.push( { id:tempRow.getItem("id"), roomName:String(params.selectedSchool) + "_" + tempRow.getItem("room_name"), roomId:room.getId(), roomAlias:String(tempRow.getItem("name")) } );
				}
			}
			
			_server.sendResponse(response, -1, null, [user])
		}
	}	
	else if (cmd == "updateRoomId")
	{
		//sql = "UPDATE student SET room_id = " + _server.escapeQuotes(params.roomId) + " WHERE ID = " + _server.escapeQuotes(params.id);
		
		//dbase.executeCommand(sql);
	}
}

function startSimulation(params)
{
	var finishedInterval = params.intervalId;
	
	var roomId = intervals[finishedInterval].roomId;
	var roomName = intervals[finishedInterval].roomName;
	
	clearInterval(intervals[finishedInterval].interval);
	
	//intervals.splice(finishedInterval, 1);
	
	intervals[finishedInterval] = null;
	
	var recipientList = [];
	var limiter = userList.length;
	
	for (var i = 0; i < limiter; i++)
	{
		var rooms = userList[i].getRoomsConnected();
		
		for (var j = 0; j < rooms.length; j++)
		{
			if (rooms[j] == roomId)
			{
				recipientList.push(userList[i]);
				break;
			}
		}
	}
	
	limiter = recipientList.length;
	var counter = 0;
	
	if (limiter == 0) return;
	
	var response = { };
	response.command = "simulationStarting";
	
	response._cmd = "simulationStarting";
	response.time = _roundTime;
	response.targetTime = _roundTime;
	
	_server.sendResponse(response, roomId, null, recipientList);
	
	var userIds = []
	
	var sql = "SELECT id, name FROM student";
	
	var queryRes = dbase.executeQuery(sql);
	
	if (queryRes && queryRes.size() > 0)
	{		
		var tempRow;
		
		for (var i = 0; i < queryRes.size(); i++)
		{
			tempRow = queryRes.get(i);
			
			for (var j = 0; j < recipientList.length; j++)
			{
				if (String(recipientList[j].getName()) == String(tempRow.getItem("name")))
				{
					userIds.push(tempRow.getItem("id"));
					break;
				}
			}
		}		
	
		var zone = _server.instance.getZone("eduFarma");
		var targetExtension = zone.getExtension("shopExt");
		
		var item = {};
		item.cmd = "beginSimulation"
		item.userList = recipientList;
		item.userIds = userIds;
		item.room = roomId;
		item.roomName = roomName;
		
		targetExtension.handleInternalRequest(item);
	}
}


/*
* This method handles internal events
* Internal events are dispactched by the Zone or Room where the extension is attached to
* 
* the (evt) object
*/
function handleInternalEvent(evt)
{
	//trace(evt.name);
	
	if (evt.name == "loginRequest")
	{
		var error = ""
		
		var nick = evt["nick"]
		var pass = evt["pass"]
		var chan = evt["chan"]
		
		/*
		* 
		* The event passes 3 arguments: the nickname used by the client, the password
		* and its "channel"
		* 
		* At the moment of login the user is only recognized by its communication channel
		* and User object for the client hasn't been already created.
		* 
		* It will be created only if the login process is successfull
		* 
		*/
		var queryRes;
		
		var obj = _server.loginUser(nick, pass, chan, true)
		
		if (obj.success == false)
		{
			error = obj.error
		}
		
		// Send response to client
		var response = new Object()
		
		if (error == "")
		{
			newUser = _server.instance.getUserByChannel(chan)
                        
			response._cmd = "logOK";
			response.id = newUser.getUserId();
			response.name = newUser.getName();
		}
		else
		{
			response._cmd = "logKO"
			response.err = error
		}	
		
		/*
		* NOTE:
		* usually the 4th parameter of the sendResponse is a list of users object that will
		* receive this message.
		* 
		* Only when handling a login request you can pass a channel instead of a list of Users
		*/
		
		_server.sendResponse(response, -1, null, chan)
	}	
	else if (evt.name == "userJoin")
	{
		var room = evt.room;
		var usr = evt.user;
		
		usr.properties.put("room", room.getId());
		
		if (String(usr.getName()).split("_")[0] != "teacher" && String(usr.getName()).split("_")[0] != "guest") 
		{
			var limiter = userList.length;
			
			for (var i = 0; i < limiter; i++)
			{
				if (parseInt(userList[i].getUserId()) == parseInt(usr.getUserId()))
				{
					userList[i] = usr;
					return;
				}
			}
			
			userList.push(usr);
		}
	}	
	else if (evt.name == "userLost")
	{
		var zone = _server.instance.getZone("eduFarma");
		var limiter = userList.length;
						
		for (var i = limiter-1; i >= 0; i--)
		{			
			//trace("USER IDS: " + userList[i].getUserId() + ", " + evt.user.getUserId());
			if (userList[i].getUserId() == evt.user.getUserId())
			{						
				for (var k = 0; k < intervals.length; k++)
				{
					//trace("ROOM IDS: " + intervals[k].roomId + ", " + userList[i].properties.get("room"));
					if (intervals[k] && parseInt(intervals[k].roomId) == parseInt(userList[i].properties.get("room")))
					{				
						var room = zone.getRoom(intervals[k].roomId);
						
						//trace("ROOM: " + room + ", " + room.getUserCount());
						if (room.getUserCount()-1 <= 1)
						{
							//trace("STOP TIMEOUT");
							clearInterval(intervals[k].interval);
							intervals.splice(k, 1);
						}
						
						break;
					}
				}			
				
				userList.splice(i, 1);
				break;
			}
		}
			
		var targetExtension = zone.getExtension("productionExt");
		
		var item = {};
		item.cmd = "terminateProcess"
		item.userServerId = evt.user.getUserId();
				
		targetExtension.handleInternalRequest(item);
	}
	
}

function handleInternalRequest(evt)
{
	if (evt.dbManager)
	{
		dbase = __db.DbManager(evt.dbManager);
	}
	else if (evt.cmd == "endSimulation")
	{
		var response = { };
		response._cmd = "endSimulation";
		response.players = evt.players;
		response.roundId = evt.roundId;
		response.roundNumber = evt.roundNumber;

		_server.sendResponse(response, -1, null, evt.recipients);
		
		handleRequest("countdownSimulation", { }, evt.recipients[0], evt.room);
		
		finishedUsers = [];
	}
}
