var _ajaxInUse = false;
var _ajaxReadyToUse = false;
jQuery(document).ready(function () {
    _ajaxReadyToUse = true;
});

// requires jQuery
var operationFailed = -1;
function GAjaxManager(options) {
    Manager = this;
    this.timer = 0;

    // opcje dla managera AJAXowego
    Manager.Options = {
        // domena strony
        Domain: '',
        // URL strony do ktorej bedzie wysylane rzadanie AJAXowe
        URL: 'ajaxpage.aspx',
        // nazwa funkcji
        Function: '',
        // nazwa namespace dla tej funkcji
        NameSpace: '',
        // funkcja wykonywana do formatowania parametrow przekazywanych dla AJAxa besposrednio ze strony na obiekcie XMLWriter, np: myFunc(XMLWriter){...}
        FormatParams: false,
        // zdarzenie wykonywane po wykonaniu poprawnego sie AJAXa lub  false - wowczas nie bedzie wykonywane, np: mySuccess(response){...}
        AfterAjax: false,
        // czy pokazywac znacznik pracy AJAXa - domyslnie wlaczone
        ShowProcessInfo: true,
        // funkcja wykonywana kiedy sukces ajaxa (nowa), jako parametr leci HTML z kontentem
        OnSuccess: false,
        // funkcja wykonywana kiedy jest blad AJAXa (nowa), jako parametr leci kontent z bledem
        OnError: false
    };
    Manager.Options = $.extend(Manager.Options, options);
    this.showInProcessInfo = function (show) {
        if (Manager.Options.ShowProcessInfo) {
            var infoDiv = $("#processing");

            $(infoDiv).css("position", "fixed");
            $(infoDiv).css("top", ($(window).height() - $(infoDiv).height()) / 2);
            $(infoDiv).css("left", ($(window).width() - $(infoDiv).width()) / 2);

            if (show) $(infoDiv).fadeIn(500);
            else $(infoDiv).fadeOut(500);
            _ajaxInUse = show;
        }
    }
    this.normalize = function toHtml(value) {
        value = value.replace(/</gi, '&lt;');
        value = value.replace(/\>/gi, '&gt;');
        return value;
    }
    this.isInt = function (t) {
        try {
            var y = parseInt(t);
            if (isNaN(y)) {
                return false;
            }
            return t == y && t.toString() == y.toString();
        }
        catch (ex) {
        }
        return false;
    }
    this.formatRequest = function () {
        var XML = new XMLWriter();
        XML.BeginNode("ajax");
        XML.BeginNode("head");
        XML.Node("namespace", Manager.Options.NameSpace);
        XML.Node("function", Manager.Options.Function);
        XML.EndNode();
        XML.BeginNode("body");
        if (typeof Manager.Options.FormatParams == 'function') {
            Manager.Options.FormatParams(XML);
        }
        XML.EndNode();
        XML.EndNode();
        XML.Close();
        return XML.ToString();
    }
    this.getXml = function (str) {
        if (window.ActiveXObject) {
            var doc = new ActiveXObject('Microsoft.XMLDOM');
            doc.async = false;
            doc.loadXML(str);
            return doc;
        } else if (window.DOMParser) {
            return (new DOMParser).parseFromString(str, 'text/xml');
        } else
            return str;
    }
    this.getString = function (xml) {
        //for IE 
        if (window.ActiveXObject) {
            return xml.xml;
        }
        // code for Mozilla, Firefox, Opera, etc.
        else {
            return (new XMLSerializer()).serializeToString(xml);
        }
    }
    this.processAfterAjax = function (result) {
        $(Manager.getXml(result)).find('ComponentXML').each(function () {
            var _errorMessage = Manager.checkError(this);
            if (_errorMessage == '') {
                var _resultList = $(this).find('Result');
                var _content = '';
                if (_resultList.length > 0) {
                    _content = _resultList[0].firstChild.nodeValue;
                }
                else {
                    _resultList = $(this).find('content');
                    if (_resultList.length > 0) {
                        _content = Manager.getString($(this).find('content')[0]);
                    }
                    else {
                        _content = Manager.getString($(this)[0]);
                    }
                }
                if (typeof Manager.Options.OnSuccess == 'function') {
                    Manager.Options.OnSuccess(_content);
                }
            }
            else {
                if (typeof Manager.Options.OnError == 'function') {
                    Manager.Options.OnError(_errorMessage);
                }
            }
        });
    }
    this.checkError = function (result) {
        var _errorList = $(result).find('error');
        if ((_errorList) && (_errorList.length > 0)) {
            return Manager.getString(_errorList[0]);
        }
        return '';
    }
    this.process = function (callback) {
        if (!_ajaxReadyToUse) {
            return;
        }
        if (_ajaxInUse) {
            return;
        }
        if (typeof Manager.Options.AfterAjax != 'function') {
            Manager.Options.AfterAjax = Manager.processAfterAjax;
        }
        var successFunction = function (result) {
            Manager.showInProcessInfo(false);
            try {
                var t = eval(result);
                // if result is less than 0, it means an error occured														
                if (Manager.isInt(t) == true && t < 0) {
                    alert("Error: " + t);
                }
                else { // if result is greater than 0 it means operation is succesfull
                    if (typeof Manager.Options.AfterAjax == 'function') {
                        Manager.Options.AfterAjax(result);
                    }
                    if (callback) callback(result);
                }
            }
            catch (ex) {	// if result is string it means operation is succesfull				
                if (typeof Manager.Options.AfterAjax == 'function') {
                    Manager.Options.AfterAjax(result);
                }
                if (callback) callback(result);
            }
        };
        var _u = Manager.Options.URL;
        if (Manager.Options.Domain != '') {
            _u = Manager.Options.Domain + '/' + Manager.Options.URL;
        }

        $.ajax({
            type: "POST",
            url: _u,
            dataType: 'html',
            data: ({ __ajax_param: Manager.normalize(Manager.formatRequest()) }),
            cache: false,
            timeout: 100000,
            beforeSend: function () { Manager.showInProcessInfo(true); },
            success: successFunction,
            failure: function (result) {
                Manager.showInProcessInfo(false);
                if (result == operationFailed) {
                    //alert("Error in ajax.")
                }
            },
            error: function (par1, par2, par3) {
                Manager.showInProcessInfo(false);
                //alert("Error in ajax..[" + par1 + "][" + par2 + "][" + par3 + "]")
            }
        });
    }
}