/**
 * spisy.js
 * @author Jędrzej Wierzejewski
 * funkcje do programowego wyświetlania lekcji, e-sprawdzianów itp.
 */

/** funkcje pomocnicze **********************/
function pokazElementKE(id) {
	var div = document.getElementById(id);
	div.removeAttribute('hidden');
} // pokazElementKE

function ukryjElementKE(id) {
	var div = document.getElementById(id);
	div.setAttribute('hidden', 'hidden');
} // ukryjElementKE

/** Lekcje **********************/
var lekcje = [
["Liczby i wyrażenia algebraiczne","lic"],
["Rachunek zdań i zbiorów. Indukcja matematyczna","set"],
["Ogólne własności funkcji. Funkcja liniowa.Równania i nierównosci liniowe. Część 1","fun"],
["Ogólne własności funkcji. Funkcja liniowa.Równania i nierównosci liniowe. Część 2","fx1"],
["Funkcja kwadratowa. Równania i nierówności kwadratowe","fx2"],
["Planimetria (część I)","pla"],
["Trygonometria (część I)","try"],
["Wielomiany i funkcje wymierne","wie"],
["Trygonometria (część II) ","tr2"],
["Geometria analityczna","ga2"],
["Ciągi liczbowe","seq"],
["Planimetria (część II)","pl2"],
["Funkcja wykładnicza i logarytmiczna","log"],
["Stereometria","ste"],
["Statystyka i rachunek prawdopodobieństwa","sta"],
// ["Rachunek różniczkowy (tylko ćwiczenia)","am1"],

];

function nr(i) {
	if (i < 2) return ""+(i+1);
	if (i == 2) return "3a";
	if (i == 3) return "3b";
	return ""+i;
}

function wyswietlSpisLekcji() {
	document.writeln("<table style='display:block; text-align:left; margin-top:20px;'>");
	for (var i=0;i<lekcje.length;i++) {		
		document.writeln("<tr><td  style='padding-right:5px;'>" + nr(i) + "</td>");
		document.writeln("<td><a  href='./lekcje/"+lekcje[i][1]+"/index.html' target='_blank'><img src='./images/" + lekcje[i][1] + ".gif' alt='" + lekcje[i][0] + "'/></a><td>");
		document.writeln("<td><a class = 'itemspis' href='./lekcje/"+lekcje[i][1]+"/index.html' target='_blank'>"+lekcje[i][0]+"</a><td>");				
		document.writeln("</tr>");
	}
	document.writeln("</table>");
} // wyswietlSpisLekcji


/** e-sprawdziany **********************/

var sprawdziany = [
["Liczby i wyrażenia algebraiczne","lic"],
["Rachunek zdań i zbiorów","set"],
["Ogólne własności funkcji. Funkcja liniowa.Równania i nierównosci liniowe","fx1"],
["Funkcja kwadratowa. Równania i nierówności kwadratowe","fx2"],
["Planimetria (część I)","pla"],
["Trygonometria (część I)","try"],
["Wielomiany i funkcje wymierne","wie"],
["Trygonometria (część II) ","tr2"],
["Geometria analityczna","ga3"],
["Ciągi liczbowe","seq"],
["Planimetria (część II)","pl2"],
["Funkcja wykładnicza i logarytmiczna","log"],
["Stereometria","ste"],
["Statystyka i rachunek prawdopodobieństwa","sta"],



];


function nazwaSprawdzianu(nr , modul , pr ) {
	return ((nr / 2)+0.99).toFixed(0)  + modul + pr + ((nr % 2) +1);  
}

function wyswietlSpisSprawdzianow() {
	
	document.writeln("<table style='display:block; text-align:left;'>");
	for (var i=0;i<sprawdziany.length;i++) {
		document.writeln("<tr>");
		document.writeln("<td><span class='spr' id='spr"+sprawdziany[i][1]+"p'>"+
				"<a class = 'itemspis' id='o"+sprawdziany[i][1]+"p' href=\"javascript:pokazSprawdziany('"+sprawdziany[i][1] + "','p');\" >&#9654; " + sprawdziany[i][0] + " (P)</a>"+
				"<a class = 'itemspis' id='z"+sprawdziany[i][1]+"p' href=\"javascript:ukryjSprawdziany('"+sprawdziany[i][1] + "','p');\" hidden>&#9660; " + sprawdziany[i][0] + " (P)</a>");
		document.writeln("</span></td>");
		document.writeln("<td>&nbsp;</td>");				
		document.writeln("<td><span class='spr' id='spr"+sprawdziany[i][1]+"r'>"+
				"<a class = 'itemspis' id='o"+sprawdziany[i][1]+"r' href=\"javascript:pokazSprawdziany('"+sprawdziany[i][1] + "','r');\" >&#9654; " + sprawdziany[i][0] + " (R)</a>"+
				"<a class = 'itemspis' id='z"+sprawdziany[i][1]+"r' href=\"javascript:ukryjSprawdziany('"+sprawdziany[i][1] + "','r');\" hidden>&#9660; " + sprawdziany[i][0] + " (R)</a>");
		document.writeln("</span></td>");
		document.writeln("</tr>");
		for (var j=0;j<4;j++) {
			document.writeln("<tr>");
			document.writeln("<td><div id = '" + nazwaSprawdzianu(j , sprawdziany[i][1] ,'p')+"' hidden>" +
					"<a class = 'itemspis' style='font-size:80%' href='./sprawdziany/"+ nazwaSprawdzianu(j , sprawdziany[i][1] ,'p') + "_testy.htm' target='_blank'>"+
					"<img src='./images/sprawdzian.gif'/>"+
					" E-sprawdzian " + nazwaSprawdzianu(j , sprawdziany[i][1] ,'p') + "</a></div></td>");
			document.writeln("<td><span hidden>&nbsp;</span></td>");
			document.writeln("<td><div id = '" + nazwaSprawdzianu(j , sprawdziany[i][1] ,'r')+"' hidden>" +
					"<a class = 'itemspis' style='font-size:80%' href='./sprawdziany/"+ nazwaSprawdzianu(j , sprawdziany[i][1] ,'r') + "_testy.htm' target='_blank'>"+
					"<img src='./images/sprawdzian.gif'/>"+
					" E-sprawdzian " + nazwaSprawdzianu(j , sprawdziany[i][1] ,'r') + "</a></div></td>");
			document.writeln("</tr>");
		}
		
	}
	document.writeln("</table>");
} // wyswietlSpisSprawdzianow



function pokazSprawdziany(id , pr) {
	ukryjElementKE("o"+id+pr);
	pokazElementKE("z"+id+pr);
	for (var j=0;j<4;j++) 
		pokazElementKE(nazwaSprawdzianu(j , id ,pr));
} // pokazSprawdziany(id , pr)

function ukryjSprawdziany(id , pr) {
	pokazElementKE("o"+id+pr);
	ukryjElementKE("z"+id+pr);
	for (var j=0;j<4;j++) 
		ukryjElementKE(nazwaSprawdzianu(j , id ,pr));
} // ukryjSprawdziany(id , pr)



/** arkusze maturalne **********************/

var arkusze = [
["Klasa 1" , "1s1", ["1s11m1","1s12m1","1s13m1"]],
["Klasa 2" , "1s2", ["1s21m1","1s22m1","1s23m1"]],
["Klasa 3" , "1s3", ["1s31m1","1s32m1","1s33m1","1s34m1"]],
["Klasa 3 poziom rozszerzony" , "2s3",
 ["2s31m1","2s32m1","2s33m1","2s34m1","2s35m1","2s36m1","2s37m1","2s38m1","2s39m1","2s30m2","2s31m2","2s32m2","2s33m2","2s34m2","2s35m2",]],
];


function nazwaArkusza(klasa , nr) {
	return arkusze[klasa][0] + " arkusz " + (nr+1);  
}

function wyswietlSpisArkuszy() {
	
	document.writeln("<table style='display:block; text-align:left;'>");
	for (var i=0;i<arkusze.length;i++) {
		document.writeln("<tr>");
		document.writeln("<td><span class='spr' id='spr"+arkusze[i][1]+"'>"+
				"<a class = 'itemspis' id='o"+arkusze[i][1]+"' href=\"javascript:pokazArkusze("+i+",'"+arkusze[i][1] + "');\" >&#9654; " + arkusze[i][0] + "</a>"+
				"<a class = 'itemspis' id='z"+arkusze[i][1]+"' href=\"javascript:ukryjArkusze("+i+",'"+arkusze[i][1] + "');\" hidden>&#9660; " + arkusze[i][0] + "</a>");
		document.writeln("</span></td>");
		document.writeln("</tr>");
		for (var j=0;j<arkusze[i][2].length;j++) {
			document.writeln("<tr>");
			document.writeln("<td><div id = '" + arkusze[i][2][j] + "' hidden>" +
					"<a class = 'itemspis' style='font-size:80%' href='./arkusze/"+arkusze[i][2][j]+"_testy.htm'  target='_blank'>"+
					"<img src='./images/sprawdzian.gif'/> Arkusz " + (j+1) + "</a>" +
							"</div></td>");
			document.writeln("</tr>");
		}
	}
	document.writeln("</table>");
} // wyswietlSpisArkuszy

function pokazArkusze(klasa , id) {
	ukryjElementKE("o"+id);
	pokazElementKE("z"+id);
	for (var j=0;j<arkusze[klasa][2].length;j++) 
		pokazElementKE(arkusze[klasa][2][j]);
} // pokazArkusze

function ukryjArkusze(klasa , id) {
	pokazElementKE("o"+id);
	ukryjElementKE("z"+id);
	for (var j=0;j<arkusze[klasa][2].length;j++)
		ukryjElementKE(arkusze[klasa][2][j]);
} // ukryjArkusze


/** etesty **********************/

var etesty = [
["z działu Liczby i wyrażenia alebraiczne" , "2lic", ["2licm1","2licm2"]],
["z działu Ogólne własności funkcji. Funkcja liniowa. Równania i nierówności liniowe" , "2fx1", ["2fx1m1","2fx1m2"]],
["z działu Funkcja kwadratowa. Równania i nierówności kwadratowe" , "2fx2", ["2fx2m1","2fx2m2"]],
["z działu Planimetria" , "2pla", ["2plam1","2plam2"]],
["z działu Trygonometria" , "2try", ["2trym1"]],
["z działu Wielomiany i funkcje wymierne" , "2wie", ["2wiem1"]],
["z działu Geometria analityczna" , "2ga2", ["2ga2m1","2ga2m2"]],
["z działu Ciągi liczbowe" , "2seq", ["2seqm1","2seqm2"]],
["z działu Funkcja wykładnicza i logarytmiczna" , "2log", ["2logm1"]],
["z działu Stereometria" , "2ste", ["2stem1","2stem2","2stem3"]],
["z działu Statystyka i rachunek prawdopodobieństwa" , "2sta", ["2stam1","2stam2"]],
];


function nazwaETestu(klasa , nr) {
	return etesty[klasa][0] + " wersja nr " + (nr+1);  
}

function wyswietlSpisETestow() {
	
	document.writeln("<table style='display:block; text-align:left;'>");
	for (var i=0;i<etesty.length;i++) {
		document.writeln("<tr>");
		document.writeln("<td><span class='spr' id='spr"+etesty[i][1]+"'>"+
				"<a class = 'itemspis' id='o"+etesty[i][1]+"' href=\"javascript:pokazETesty("+i+",'"+etesty[i][1] + "');\" >&#9654; e-Testy " + etesty[i][0] + "</a>"+
				"<a class = 'itemspis' id='z"+etesty[i][1]+"' href=\"javascript:ukryjETesty("+i+",'"+etesty[i][1] + "');\" hidden>&#9660; e-Testy " + etesty[i][0] + "</a>");
		document.writeln("</span></td>");
		document.writeln("</tr>");
		for (var j=0;j<etesty[i][2].length;j++) {
			document.writeln("<tr>");
			document.writeln("<td><div id = '" + etesty[i][2][j] + "' hidden>" +
				"<a class = 'itemspis' style='font-size:80%' href='./etesty/"+etesty[i][2][j]+"_testy.htm'  target='_blank'>"+
				"<img src='./images/sprawdzian.gif'/> e-Test " + nazwaETestu(i,j) + "</a></div></td>");
			document.writeln("</tr>");
		}
	}
	document.writeln("</table>");
} // wyswietlSpisETestow

function pokazETesty(klasa , id) {
	ukryjElementKE("o"+id);
	pokazElementKE("z"+id);
	for (var j=0;j<etesty[klasa][2].length;j++) 
		pokazElementKE(etesty[klasa][2][j]);
} // pokazETesty

function ukryjETesty(klasa , id) {
	pokazElementKE("o"+id);
	ukryjElementKE("z"+id);
	for (var j=0;j<etesty[klasa][2].length;j++)
		ukryjElementKE(etesty[klasa][2][j]);
} // ukryjETesty

