<?php

require_once 'EntrepreneurController.php';

class AdministratorController extends EntrepreneurController
{
    public function init()
    {
        parent::init();
        if ($this->user == null)
            $this->_redirectExit('open-id', 'auth');

        if ($this->user->isAdmin() == false)
            $this->_redirectExit('index', 'index');

        $this->view->showEUfooter = false;
    }

    public function indexAction()
    {
    }

    public function languagesAction()
    {
        $mLanguage = new Model_Language;
        if (isset($_POST['id'])) {
            $where = $mLanguage->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $mLanguage->delete($where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s języków usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Języków usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mLanguage->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s języków aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Języków aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mLanguage->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s języków zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Języków zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mLanguage->_parseLanguagesParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mLanguage->languages($this->view->params);
    }

    public function languageAction()
    {
        $mLanguage = new Model_Language;
        $id = $this->_request->getParam('id');
        if (isset($_POST['iso_code']) && isset($_POST['language_code']) && isset($_POST['name'])) {
            if ($id) {
                $data = array(
                    'iso_code' => strtolower($_POST['iso_code']),
                    'language_code' => $_POST['language_code'],
                    'name' => $_POST['name'],
                    'active' => $_POST['active']
                );
                $where = $mLanguage->getAdapter()->quoteInto('id = ?', $id);
                $mLanguage->update($data, $where);
                $this->_flash($this->view->translate('Język %s został zapisany', $_POST['name']), 'success');
            } else {
                $data = array(
                    'iso_code' => strtolower($_POST['iso_code']),
                    'language_code' => $_POST['language_code'],
                    'name' => $_POST['name'],
                    'active' => $_POST['active']
                );
                $id = $mLanguage->insert($data);
                if ($id) {
                    $this->_flash($this->view->translate('Język %s został dodany', $_POST['name']), 'success');
                }
            }
        }
        if (isset($id)) {
            $this->view->item = $mLanguage->getById($id);
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj język') . ': ' . $this->view->item->name
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj język')
            );
        }
    }

    public function languageDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mLanguage = new Model_Language;
            $where = $mLanguage->getAdapter()->quoteInto('id = ?', $id);
            $mLanguage->delete($where);
        }
        $this->_redirect('administrator/languages');
    }

    public function taxesAction()
    {
        $mTax = new Model_Tax;
        $mTaxLang = new Model_TaxLang;

        if (isset($_POST['id'])) {
            $where = $mTax->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mTax->getAdapter()->quoteInto('tax_id IN(?)', $_POST['id']);
                $mTax->delete($where);
                $mTaxLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s podatków usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Podatków usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mTax->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s podatków aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Podatków aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mTax->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s podatków zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Podatków zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mTax->_parseTaxesParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mTax->taxes($this->view->params);
    }

    public function taxAction()
    {
        $mTax = new Model_Tax;
        $mTaxLang = new Model_TaxLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cash' => strtolower($_POST['cash']),
                    'percent' => $_POST['percent'],
                    'frequency' => $_POST['frequency'],
                    'active' => $_POST['active']
                );
                $where = $mTax->getAdapter()->quoteInto('id = ?', $id);
                $mTax->update($data, $where);
                $tax = $mTax->getById($id);
                $tax->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Podatek zapisano.'), 'success');
            } else {
                $data = array(
                    'cash' => strtolower($_POST['cash']),
                    'percent' => $_POST['percent'],
                    'frequency' => $_POST['frequency'],
                    'active' => $_POST['active']
                );
                $id = $mTax->insert($data);
                if (isset($id)) {
                    $tax = $mTax->getById($id);
                    $tax->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Podatek zapisano.'), 'success');
                    $this->_redirect('/administrator/tax/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/taxes');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mTax->getById($id);
            if (isset($this->view->item->id)) {
                $this->view->translations = $this->view->item->loadTranslations();
                $this->view->pageTitle = array(
                    'label' => $this->view->translate('Edytuj podatek') . ': ' . $this->view->item->name($this->lang->id)
                );
            } else {
                $this->_redirect('/administrator/taxes');
            }
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj podatek')
            );
        }

    }

    public function taxDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mTax = new Model_Tax;
            $mTaxLang = new Model_TaxLang;
            $where = $mTax->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mTaxLang->getAdapter()->quoteInto('tax_id = ?', $id);
            $mTax->delete($where);
            $mTaxLang->delete($where_l);
        }
        $this->_redirect('administrator/taxes');
    }

    public function eventsAction()
    {
        $mEvent = new Model_Event;
        $mEventLang = new Model_EventLang;

        if (isset($_POST['id'])) {
            $where = $mEvent->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mEvent->getAdapter()->quoteInto('event_id IN(?)', $_POST['id']);
                $mEvent->delete($where);
                $mEventLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s zdarzeń usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Zdarzenie usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mEvent->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s zdarzeń aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Zdarzenie aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mEvent->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s zdarzeń zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Zdarzenie zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mEvent->_parseEventsParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mEvent->events($this->view->params);
    }

    public function eventAction()
    {
        $mEvent = new Model_Event;
        $mEventLang = new Model_EventLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name'])
            && is_array($_POST['language_id'])
            && is_array($_POST['name'])
            && is_array($_POST['description'])
            && count($_POST['name']) > 0
            && count($_POST['name']) == count($_POST['language_id'])
            && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cash' => strtolower($_POST['cash']),
                    'percent' => $_POST['percent'],
                    'allow_once' => $_POST['allow_once'],
                    'active' => $_POST['active']
                );
                $where = $mEvent->getAdapter()->quoteInto('id = ?', $id);
                $mEvent->update($data, $where);
                $event = $mEvent->getById($id);
                $event->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Zdarzenie zapisano.'), 'success');
            } else {
                $data = array(
                    'cash' => strtolower($_POST['cash']),
                    'percent' => $_POST['percent'],
                    'allow_once' => $_POST['allow_once'],
                    'active' => $_POST['active']
                );
                $id = $mEvent->insert($data);
                if (isset($id)) {
                    $event = $mEvent->getById($id);
                    $event->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Zdarzenie zapisano.'), 'success');
                    $this->_redirect('/administrator/event/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/events');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mEvent->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj zdarzenie') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj zdarzenie')
            );
        }
    }

    public function eventDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mEvent = new Model_Event;
            $mEventLang = new Model_EventLang;
            $where = $mEvent->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mEventLang->getAdapter()->quoteInto('event_id = ?', $id);
            $mEvent->delete($where);
            $mEventLang->delete($where_l);
        }
        $this->_redirect('administrator/events');
    }

    public function mapsAction()
    {
        $mMap = new Model_Map;
        $mMapLang = new Model_MapLang;
        if (isset($_POST['id'])) {
            $where = $mMap->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mMap->getAdapter()->quoteInto('map_id IN(?)', $_POST['id']);
                $mMap->delete($where);
                $mMapLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s map usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Mapę usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mMap->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s map aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Mapę aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mMap->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s map zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Mapę zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mMap->_parseMapsParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mMap->maps($this->view->params);
    }

    public function mapAction()
    {
        $mMap = new Model_Map;
        $mMapLang = new Model_MapLang;

        $id = $this->_request->getParam('id');
        if (isset($id) && isset($_POST['fields']) && isset($_POST['fields_v']) && isset($_POST['fields_h'])) {
            $data = array(
                'fields' => $_POST['fields'],
                'fields_h' => $_POST['fields_h'],
                'fields_v' => $_POST['fields_v'],
            );
            $where = $mMap->getAdapter()->quoteInto('id = ?', $id);
            $mMap->update($data, $where);
        }
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'bitmap' => $_POST['bitmap'],
                    'width' => $_POST['width'],
                    'height' => $_POST['height'],
                    'active' => $_POST['active']
                );
                $where = $mMap->getAdapter()->quoteInto('id = ?', $id);
                $mMap->update($data, $where);
                $map = $mMap->getById($id);
                $map->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Mapę zapisano.'), 'success');
            } else {
                $data = array(
                    'bitmap' => $_POST['bitmap'],
                    'width' => $_POST['width'],
                    'height' => $_POST['height'],
                    'active' => $_POST['active']
                );
                $id = $mMap->insert($data);
                if (isset($id)) {
                    $map = $mMap->getById($id);
                    $map->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Mapę zapisano.'), 'success');
                    $this->_redirect('/administrator/map/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/maps');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mMap->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj mapę') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj mapę')
            );
        }
    }

    public function mapDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mMap = new Model_Map;
            $mMapLang = new Model_MapLang;
            $where = $mMap->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mMapLang->getAdapter()->quoteInto('map_id = ?', $id);
            $mMap->delete($where);
            $mMapLang->delete($where_l);
        }
        $this->_redirect('administrator/maps');
    }

    public function mapFieldsAction()
    {
        $mMap = new Model_Map;
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $this->view->item = $mMap->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageSubTitle = array(
                'label' => $this->view->translate('Edytuj mapę') . ': ' . $this->view->item->name($this->lang->id),
                'link' => '/administrator/map/id/' . $id
            );
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj pola na mapie') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->_redirect('/administrator/maps');
        }
    }

    public function missionsAction()
    {
        $mMission = new Model_Mission;
        $mMissionLang = new Model_MissionLang;

        if (isset($_POST['id'])) {
            $where = $mMission->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mMission->getAdapter()->quoteInto('mission_id IN(?)', $_POST['id']);
                $mMission->delete($where);
                $mMissionLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s misji usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Misję usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mMission->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s misji aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Misję aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mMission->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s misję zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Misję zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mMission->_parseMissionsParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mMission->missions($this->view->params);
    }

    public function missionAction()
    {
        $mMission = new Model_Mission;
        $mMissionLang = new Model_MissionLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'map_id' => $_POST['map_id'],
                    'goal_cash' => $_POST['goal_cash'],
                    'goal_regions' => $_POST['goal_regions'],
                    'goal_map_regions_count' => $_POST['goal_map_regions_count'],
                    'goal_map_regions_percent' => $_POST['goal_map_regions_percent'],
                    'goal_factory_level_id' => $_POST['goal_factory_level_id'],
                    'goal_limit_rounds' => $_POST['goal_limit_rounds'],
                    'active' => $_POST['active']
                );
                $where = $mMission->getAdapter()->quoteInto('id = ?', $id);
                $mMission->update($data, $where);
                $mission = $mMission->getById($id);
                $mission->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Misja zapisano.'), 'success');
            } else {
                $data = array(
                    'map_id' => $_POST['map_id'],
                    'goal_cash' => $_POST['goal_cash'],
                    'goal_regions' => $_POST['goal_regions'],
                    'goal_map_regions_count' => $_POST['goal_map_regions_count'],
                    'goal_map_regions_percent' => $_POST['goal_map_regions_percent'],
                    'goal_factory_level_id' => $_POST['goal_factory_level_id'],
                    'goal_limit_rounds' => $_POST['goal_limit_rounds'],
                    'active' => $_POST['active']
                );
                $id = $mMission->insert($data);
                if (isset($id)) {
                    $mission = $mMission->getById($id);
                    $mission->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Misja zapisana.'), 'success');
                    $this->_redirect('/administrator/mission/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/missions');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mMission->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj misję') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj misję')
            );
        }
    }

    public function missionDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mMission = new Model_Mission;
            $mMissionLang = new Model_MissionLang;
            $where = $mMission->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mMissionLang->getAdapter()->quoteInto('mission_id = ?', $id);
            $mMission->delete($where);
            $mMissionLang->delete($where_l);
        }
        $this->_redirect('administrator/missions');
    }

    public function factoryLevelsAction()
    {
        $mFactoryLevel = new Model_FactoryLevel;
        $mFactoryLevelLang = new Model_FactoryLevelLang;

        if (isset($_POST['id'])) {
            $where = $mFactoryLevel->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mFactoryLevel->getAdapter()->quoteInto('factory_level_id IN(?)', $_POST['id']);
                $mFactoryLevel->delete($where);
                $mFactoryLevelLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s fabryk usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Fabrykę usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mFactoryLevel->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s fabryk aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Fabrykę aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mFactoryLevel->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s fabryk zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Fabrykę zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mFactoryLevel->_parseFactoryLevelsParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mFactoryLevel->factory_levels($this->view->params);
    }

    public function factoryLevelAction()
    {
        $mFactoryLevel = new Model_FactoryLevel;
        $mFactoryLevelLang = new Model_FactoryLevelLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cost' => $_POST['cost'],
                    'production' => $_POST['production'],
                    'staff' => $_POST['staff'],
                    'active' => $_POST['active']
                );
                $where = $mFactoryLevel->getAdapter()->quoteInto('id = ?', $id);
                $mFactoryLevel->update($data, $where);
                $factory_level = $mFactoryLevel->getById($id);
                $factory_level->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Fabrykę zapisano.'), 'success');
            } else {
                $data = array(
                    'cost' => $_POST['cost'],
                    'production' => $_POST['production'],
                    'active' => $_POST['active']
                );
                $id = $mFactoryLevel->insert($data);
                if (isset($id)) {
                    $factory_level = $mFactoryLevel->getById($id);
                    $factory_level->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Fabrykę zapisana.'), 'success');
                    $this->_redirect('/administrator/factory-level/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/factory-levels');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mFactoryLevel->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj fabrykę') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj fabrykę')
            );
        }
    }

    public function factoryProductAction()
    {
        $mFactoryLevel = new Model_FactoryLevel;
        $mFactoryLevelLang = new Model_FactoryLevelLang;
        $mFactoryProduct = new Model_FactoryProduct;
        $mProduct = new Model_Product;

        $id = $this->_request->getParam('id');
        if (isset($id)) {

            if (isset($_POST['factory_product']) && isset($_POST['product_id']) && isset($_POST['factory_product_id'])) {
                // echo '<pre>'; print_r($_POST); die;
                if (count($_POST['factory_product']) == count($_POST['factory_product_id'])) {
                    foreach ($_POST['factory_product'] as $k => $p) {
                        if ($_POST['factory_product_id'][$k] > 0) {
                            $data = array(
                                'product_id' => $_POST['product_id'][$k],
                                'factory_id' => $id,
                                'production' => (int) $p
                            );
                            $where = $mFactoryProduct->getAdapter()
                                ->quoteInto('id = ?', $_POST['factory_product_id'][$k]);
                            $mFactoryProduct->update($data, $where);
                        } else {
                            $data = array(
                                'product_id' => $_POST['product_id'][$k],
                                'factory_id' => $id,
                                'production' => (int) $p
                            );
                            $mFactoryProduct->insert($data);
                        }
                    }
                    $this->_flash($this->view->translate('Wielkość produkcji zapisano.'), 'success');
                }
            }

            $this->view->item = $mFactoryLevel->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj wielkość produkcji') . ': ' . $this->view->item->name($this->lang->id)
            );
            $this->view->fields = array();
            $products = $mProduct->getAllActive();
            $factory_product = $mFactoryProduct->byFactoryId($id);
            $factory_product_by_product_id = array();
            if (count($factory_product) > 0) {
                foreach ($factory_product as $fp) {
                    $factory_product_by_product_id[$fp->product_id] = $fp->toArray();
                }
            }
            foreach ($products as $key => $product) {
                $value = '';
                $fp_id = 0;
                if (isset($factory_product_by_product_id[$product->id]['id'])) {
                    $value = $factory_product_by_product_id[$product->id]['production'];
                    $fp_id = $factory_product_by_product_id[$product->id]['id'];
                }
                $this->view->fields[] = array(
                    'type' => 'hidden',
                    'name' => 'factory_product_id[]',
                    'value' => $fp_id
                );
                $this->view->fields[] = array(
                    'type' => 'hidden',
                    'name' => 'product_id[]',
                    'value' => $product->id
                );
                $this->view->fields[] = array(
                    'title' => $product->name(1),
                    'name' => 'factory_product[]',
                    'required' => false,
                    'validation' => 'integer',
                    'value' => $value
                );
            }
        } else {
            $this->_redirect('/administrator/factory-levels');
        }
    }

    public function factoryLevelDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mFactoryLevel = new Model_FactoryLevel;
            $mFactoryLevelLang = new Model_FactoryLevelLang;
            $where = $mFactoryLevel->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mFactoryLevelLang->getAdapter()->quoteInto('factory_level_id = ?', $id);
            $mFactoryLevel->delete($where);
            $mFactoryLevelLang->delete($where_l);
        }
        $this->_redirect('administrator/factory-levels');
    }

    public function productsAction()
    {
        $mProduct = new Model_Product;
        $mProductLang = new Model_ProductLang;

        if (isset($_POST['id'])) {
            $where = $mProduct->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mProduct->getAdapter()->quoteInto('factory_level_id IN(?)', $_POST['id']);
                $mProduct->delete($where);
                $mProductLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s produktów usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Produkt usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mProduct->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s produktów aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Produkt aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mProduct->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s produktów zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Produkt zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mProduct->_parseProductsParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mProduct->products($this->view->params);
    }

    public function productAction()
    {
        $mProduct = new Model_Product;
        $mProductLang = new Model_ProductLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cost' => $_POST['cost'],
                    'profit' => $_POST['profit'],
                    'weight' => $_POST['weight'],
                    'factory_level_id' => $_POST['factory_level_id'],
                    'shop_level_id' => $_POST['shop_level_id'],
                    'active' => $_POST['active']
                );
                $where = $mProduct->getAdapter()->quoteInto('id = ?', $id);
                $mProduct->update($data, $where);
                $factory_level = $mProduct->getById($id);
                $factory_level->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Produkt zapisano.'), 'success');
            } else {
                $data = array(
                    'cost' => $_POST['cost'],
                    'profit' => $_POST['profit'],
                    'weight' => $_POST['weight'],
                    'factory_level_id' => $_POST['factory_level_id'],
                    'shop_level_id' => $_POST['shop_level_id'],
                    'active' => $_POST['active']
                );
                $id = $mProduct->insert($data);
                if (isset($id)) {
                    $factory_level = $mProduct->getById($id);
                    $factory_level->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Produkt zapisano.'), 'success');
                    $this->_redirect('/administrator/product/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/products');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mProduct->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj produkt') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj produkt')
            );
        }
    }

    public function productDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mProduct = new Model_Product;
            $mProductLang = new Model_ProductLang;
            $where = $mProduct->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mProductLang->getAdapter()->quoteInto('product_id = ?', $id);
            $mProduct->delete($where);
            $mProductLang->delete($where_l);
        }
        $this->_redirect('administrator/products');
    }

    public function shopsAction()
    {
        $mShop = new Model_Shop;
        $mShopLang = new Model_ShopLang;

        if (isset($_POST['id'])) {
            $where = $mShop->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mShop->getAdapter()->quoteInto('factory_level_id IN(?)', $_POST['id']);
                $mShop->delete($where);
                $mShopLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s sklepów usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Sklep usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mShop->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s sklepów aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Sklep aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mShop->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s sklepów zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Sklep zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mShop->_parseShopsParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mShop->shops($this->view->params);
    }

    public function shopAction()
    {
        $mShop = new Model_Shop;
        $mShopLang = new Model_ShopLang;
        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cost' => $_POST['cost'],
                    'sale' => $_POST['sale'],
                    'staff' => $_POST['staff'],
                    'factory_level_id' => $_POST['factory_level_id'],
                    'active' => $_POST['active']
                );
                $where = $mShop->getAdapter()->quoteInto('id = ?', $id);
                $mShop->update($data, $where);
                $factory_level = $mShop->getById($id);
                $factory_level->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Sklep zapisano.'), 'success');
            } else {
                $data = array(
                    'cost' => $_POST['cost'],
                    'sale' => $_POST['sale'],
                    'staff' => $_POST['staff'],
                    'factory_level_id' => $_POST['factory_level_id'],
                    'active' => $_POST['active']
                );
                $id = $mShop->insert($data);
                if (isset($id)) {
                    $factory_level = $mShop->getById($id);
                    $factory_level->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Sklep zapisano.'), 'success');
                    $this->_redirect('/administrator/shop/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/shops');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mShop->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj sklep') . ': ' . $this->view->item->name($this->lang->id)
            );
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj sklep')
            );
        }
    }

    public function shopProductAction()
    {
        $mShop = new Model_Shop;
        $mShopLang = new Model_ShopLang;
        $mShopProduct = new Model_ShopProduct;
        $mProduct = new Model_Product;

        $id = $this->_request->getParam('id');
        if (isset($id)) {

            if (isset($_POST['shop_product']) && isset($_POST['product_id']) && isset($_POST['shop_product_id'])) {
                // echo '<pre>'; print_r($_POST); die;
                if (count($_POST['shop_product']) == count($_POST['shop_product_id'])) {
                    foreach ($_POST['shop_product'] as $k => $p) {
                        if ($_POST['shop_product_id'][$k] > 0) {
                            $data = array(
                                'product_id' => $_POST['product_id'][$k],
                                'shop_id' => $id,
                                'sale' => (int) $p
                            );
                            $where = $mShopProduct->getAdapter()->quoteInto('id = ?', $_POST['shop_product_id'][$k]);
                            $mShopProduct->update($data, $where);
                        } else {
                            $data = array(
                                'product_id' => $_POST['product_id'][$k],
                                'shop_id' => $id,
                                'sale' => (int) $p
                            );
                            $mShopProduct->insert($data);
                        }
                    }
                    $this->_flash($this->view->translate('Wielkość sprzedaży zapisano.'), 'success');
                }
            }

            $this->view->item = $mShop->getById($id);
            $this->view->translations = $this->view->item->loadTranslations();
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Edytuj wielkość sprzedaży') . ': ' . $this->view->item->name($this->lang->id)
            );
            $this->view->fields = array();
            $products = $mProduct->getAllActive();
            $shop_product = $mShopProduct->byShopId($id);
            $shop_product_by_product_id = array();
            if (count($shop_product) > 0) {
                foreach ($shop_product as $fp) {
                    $shop_product_by_product_id[$fp->product_id] = $fp->toArray();
                }
            }
            foreach ($products as $key => $product) {
                $value = '';
                $fp_id = 0;
                if (isset($shop_product_by_product_id[$product->id]['id'])) {
                    $value = $shop_product_by_product_id[$product->id]['sale'];
                    $fp_id = $shop_product_by_product_id[$product->id]['id'];
                }
                $this->view->fields[] = array(
                    'type' => 'hidden',
                    'name' => 'shop_product_id[]',
                    'value' => $fp_id
                );
                $this->view->fields[] = array(
                    'type' => 'hidden',
                    'name' => 'product_id[]',
                    'value' => $product->id
                );
                $this->view->fields[] = array(
                    'title' => $product->name(1),
                    'name' => 'shop_product[]',
                    'required' => false,
                    'validation' => 'integer',
                    'value' => $value
                );
            }
        } else {
            $this->_redirect('/administrator/shops');
        }
    }

    public function shopDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mShop = new Model_Shop;
            $mShopLang = new Model_ShopLang;
            $where = $mShop->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mShopLang->getAdapter()->quoteInto('shop_id = ?', $id);
            $mShop->delete($where);
            $mShopLang->delete($where_l);
        }
        $this->_redirect('administrator/shops');
    }

    public function usersAction()
    {
        $mUser = new Model_User;
        if (isset($_POST['id'])) {
            $where = $mUser->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $mUser->delete($where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s użytkowników usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Użytkowników usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mUser->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s użytkowników aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Użytkowników aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mUser->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s użytkowników zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Użytkowników zdeaktywowano.'), 'success');
                }
            } elseif (isset($_POST['user'])) {
                $data = array('user_role' => 3);
                $mUser->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s użytkowników zostało zwykłymi misiami.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Użytkownik został zwykłym misiem.'), 'success');
                }
            } elseif (isset($_POST['administrator'])) {
                $data = array('user_role' => 1);
                $mUser->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s użytkowników zostało mianowanych administratorami.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Użytkownik został mianowany adminem.'), 'success');
                }
            }
        }
        $this->view->params = $mUser->_parseUsersParams($this->getRequest()->getParams());
        $this->ZendSession->usersParams = $this->view->params;
        $this->view->items = $mUser->users($this->view->params);
    }

    public function banksAction()
    {
        $mBank = new Model_Bank;
        $mBankLang = new Model_BankLang;

        if (isset($_POST['id'])) {
            $where = $mBank->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mBank->getAdapter()->quoteInto('bank_id IN(?)', $_POST['id']);
                $mBank->delete($where);
                $mBankLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s ofert banku usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Ofert banku usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mBank->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s ofert banku aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Ofert banku aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mBank->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s ofert banku zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Ofert banku zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mBank->_parseBanksParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mBank->banks($this->view->params);
    }

    public function bankAction()
    {
        $mBank = new Model_Bank;
        $mBankLang = new Model_BankLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cost' => $_POST['cost'],
                    'income' => $_POST['income'],
                    'required_income' => $_POST['required_income'],
                    'required_cash' => $_POST['required_cash'],
                    'required_round' => $_POST['required_round'],
                    'required_factory' => $_POST['required_factory'],
                    'risk' => $_POST['risk'],
                    'duration' => $_POST['duration'],
                    'active' => $_POST['active']
                );
                $where = $mBank->getAdapter()->quoteInto('id = ?', $id);
                $mBank->update($data, $where);
                $bank = $mBank->getById($id);
                $bank->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Ofertę banku zapisano.'), 'success');
            } else {
                $data = array(
                    'cost' => $_POST['cost'],
                    'income' => $_POST['income'],
                    'required_income' => $_POST['required_income'],
                    'required_cash' => $_POST['required_cash'],
                    'required_round' => $_POST['required_round'],
                    'required_factory' => $_POST['required_factory'],
                    'risk' => $_POST['risk'],
                    'duration' => $_POST['duration'],
                    'active' => $_POST['active']
                );
                $id = $mBank->insert($data);
                if (isset($id)) {
                    $bank = $mBank->getById($id);
                    $bank->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Ofertę banku zapisano.'), 'success');
                    $this->_redirect('/administrator/bank/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/banks');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mBank->getById($id);
            if (isset($this->view->item->id)) {
                $this->view->translations = $this->view->item->loadTranslations();
                $this->view->pageTitle = array(
                    'label' => $this->view->translate('Edytuj ofertę banku') . ': ' . $this->view->item->name($this->lang->id)
                );
            } else {
                $this->_redirect('/administrator/banks');
            }
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj ofertę bankową')
            );
        }

    }

    public function bankDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mBank = new Model_Bank;
            $mBankLang = new Model_BankLang;
            $where = $mBank->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mBankLang->getAdapter()->quoteInto('bank_id = ?', $id);
            $mBank->delete($where);
            $mBankLang->delete($where_l);
        }
        $this->_redirect('administrator/banks');
    }

    public function deliveriesAction()
    {
        $mDelivery = new Model_Delivery;
        $mDeliveryLang = new Model_DeliveryLang;

        if (isset($_POST['id'])) {
            $where = $mDelivery->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $lang_where = $mDelivery->getAdapter()->quoteInto('delivery_id IN(?)', $_POST['id']);
                $mDelivery->delete($where);
                $mDeliveryLang->delete($lang_where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s metod dystrybucji usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Metodę dystrybucji usunięto.'), 'success');
                }
            } elseif (isset($_POST['activate'])) {
                $data = array('active' => 1);
                $mDelivery->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s metod dystrybucji aktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Metodę dystrybucji aktywowano.'), 'success');
                }
            } elseif (isset($_POST['deactivate'])) {
                $data = array('active' => 0);
                $mDelivery->update($data, $where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s metod dystrybucji zdeaktywowano.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Metodę dystrybucji zdeaktywowano.'), 'success');
                }
            }
        }
        $this->view->params = $mDelivery->_parseDeliveriesParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mDelivery->deliveries($this->view->params);
    }

    public function deliveryAction()
    {
        $mDelivery = new Model_Delivery;
        $mDeliveryLang = new Model_DeliveryLang;

        $id = $this->_request->getParam('id');
        if (isset($_POST['name']) && is_array($_POST['language_id']) && is_array($_POST['name']) && is_array($_POST['description']) && count($_POST['name']) > 0 && count($_POST['name']) == count($_POST['language_id']) && count($_POST['description']) == count($_POST['language_id'])
        ) {
            if ($id) {
                $data = array(
                    'cost' => $_POST['cost'],
                    'capacity' => $_POST['capacity'],
                    'active' => $_POST['active']
                );
                $where = $mDelivery->getAdapter()->quoteInto('id = ?', $id);
                $mDelivery->update($data, $where);
                $delivery = $mDelivery->getById($id);
                $delivery->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                $this->_flash($this->view->translate('Metodę dystrybucji zapisano.'), 'success');
            } else {
                $data = array(
                    'cost' => $_POST['cost'],
                    'capacity' => $_POST['capacity'],
                    'active' => $_POST['active']
                );
                $id = $mDelivery->insert($data);
                if (isset($id)) {
                    $delivery = $mDelivery->getById($id);
                    $delivery->saveTranslations($_POST['language_id'], $_POST['name'], $_POST['description']);
                    $this->_flash($this->view->translate('Metodę dystrybucji zapisano.'), 'success');
                    $this->_redirect('/administrator/delivery/id/' . $id);
                } else {
                    $this->_flash($this->view->translate('Wystapił błąd.'), 'error');
                    $this->_redirect('/administrator/deliveries');
                }
            }
        } elseif (isset($_POST['name'])) {
            $this->_flash($this->view->translate('Wystąpił błąd') . ': ' . $this->view->translate('brak danych językowych'), 'error');
        }
        if (isset($id)) {
            $this->view->item = $mDelivery->getById($id);
            if (isset($this->view->item->id)) {
                $this->view->translations = $this->view->item->loadTranslations();
                $this->view->pageTitle = array(
                    'label' => $this->view->translate('Edytuj metodę dystrybucji') . ': ' . $this->view->item->name($this->lang->id)
                );
            } else {
                $this->_redirect('/administrator/deliveries');
            }
        } else {
            $this->view->pageTitle = array(
                'label' => $this->view->translate('Dodaj metodę dystrybucji')
            );
        }

    }

    public function deliveryDeleteAction()
    {
        $id = $this->_request->getParam('id');
        if (isset($id)) {
            $mDelivery = new Model_Delivery;
            $mDeliveryLang = new Model_DeliveryLang;
            $where = $mDelivery->getAdapter()->quoteInto('id = ?', $id);
            $where_l = $mDeliveryLang->getAdapter()->quoteInto('delivery_id = ?', $id);
            $mDelivery->delete($where);
            $mDeliveryLang->delete($where_l);
        }
        $this->_redirect('administrator/deliveries');
    }

    /**
     * @return Model_GameRow
     */
    protected function _getGameById()
    {
        $id = $this->_getParam('id');
        if ($id == null) {
            $this->_flash($this->view->translate('Nie podano ID'), 'error');
            $this->_redirectBack();
        }

        $modelGame = new Model_Game;
        $game = $modelGame->find($id)->current();

        if ($game == null) {
            $this->_flash($this->view->translate('Nie znaleziono gry o podanym ID'), 'error');
            $this->_redirectBack();
        }

        return $game;
    }

    public function rankGamesAction()
    {
        $this->_forward('index', 'rank');
    }

    public function editRankGameAction()
    {
        $game = $this->_getGameById();

        if ($this->_request->isPost()) {
            $postData = $this->_request->getPost();
            $game->setFromArray($postData);
            $game->save();

            $this->_flash($this->view->translate('Zmiany zostały zapisane'), 'success');
        }

        $this->view->game = $game;
    }

    public function deleteRankGame()
    {
        $game = $this->_getGameById();
        $game->delete();

        $this->_flash($this->view->translate('Gra została usunięta'), 'success');
        $this->_redirectExit('rank-games');
    }
}

