<?php

require_once 'EntrepreneurController.php';

class GameController extends EntrepreneurController
{
    /**
     * @var Model_GameRow
     */
    protected $game;

    /**
     * @var Model_MissionRow
     */
    protected $mission;

    /**
     * @var Model_MapRow
     */
    protected $map;

    /**
     * @var Model_GameMapRow
     */
    protected $gameMap;

    public function init()
    {
        parent::init();

        if ($this->_request->isXmlHttpRequest()) {
            $this->view->layout()->disableLayout();
        }
    }

    // Funkcja sprawdzająca czy w sesji jest jakis stan gry, czy jest nadal aktywny, etc...
    public function loadGame()
    {
        if (!isset($this->ZendSession->game_id)) {
            $this->_redirectUrlExit('/');
        }

        $mGame = new Model_Game;
        $mMission = new Model_Mission;
        $mMap = new Model_Map;

        $this->game = $mGame->getById($this->ZendSession->game_id);
        // Sprawdź czy wczytano gre i czy nadal jest aktywna
        if (!isset($this->game->id))
            $this->_redirectExit('index', 'index');

        $this->gameMap = $this->game->getGameMap();
        if (!isset($this->gameMap->id))
            $this->_redirectExit('index', 'index');

        $this->mission = $mMission->getById($this->game->mission_id);
        if (!isset($this->mission->id))
            $this->_redirectExit('index', 'index');

        $this->map = $mMap->getById($this->mission->map_id);
        if (!isset($this->map->id))
            $this->_redirectExit('index', 'index');

        $this->view->game = $this->game;
        $this->view->gameData = $this->game->getGameData();
        $this->view->mission = $this->mission;
        $this->view->map = $this->map;
        $this->view->gameMap = $this->gameMap;
    }

    // DEBUG!
    public function debugAction()
    {
        if ($this->user && $this->user->user_role > 1)
            $this->_redirectExit('index');

        $this->loadGame();
        echo '<pre>';
        print_r($this->game);
        die;
    }

    // DEBUG!
    public function debugMapAction()
    {
        if ($this->user && $this->user->user_role > 1)
            $this->_redirectExit('index');

        $this->loadGame();
        echo '<pre>';
        print_r($this->game->getGameMap()->fields_shops);
        die;
    }

    // DEBUG!
    public function debugSpecialAction()
    {
        if ($this->user && $this->user->user_role > 1)
            $this->_redirectExit('index');

        $this->loadGame();
        $d = $this->game->isGameOver($this->app['bankrupt']);
        if ($d != null) {
            echo '<pre>';
            print_r($d);
        } else {
            echo 'NULL';
        }
        die;
    }

    public function indexAction()
    {
        $this->loadGame();

        if ($this->game->bankrupt)
            $this->_redirectExit('bankrupt');

        if ($this->game->mission_objectives)
            $this->_redirectExit('mission-complete');
    }

    public function newAction()
    {

    }

    public function missionAction()
    {
        $this->loadGame();
    }

    public function startAction()
    {
        if ($missionID = $this->_getParam('mission_id')) {
            $playerName = $this->_getParam('player_name');
            if ($playerName) {
                $v = new GN_Validate_Censorship(APPLICATION_PATH . '/resources/languages/pl_censored.php');
                if (!$v->isValid($playerName)) {
                    $this->_flash($this->view->translate('Podana fraza zawiera wyraz powszechnie uważany za wulgaryzm.'), 'error');
                    $this->_redirectBack();
                }
            }

            $mGame = new Model_Game;
            $game = $mGame->createNewGame($missionID, $this->user);
            if ($this->user && !empty($this->user->name)) {
                $game->player_name = $this->user->name;
                $game->save();
            } else if ($playerName) {
                $game->player_name = $playerName;
                $game->save();
            }
            $this->ZendSession->game_id = $game->id;
            $this->_redirectExit('index');
        }
    }

    // Menu fabryka
    public function factoryAction()
    {
        $this->loadGame();
        $mFactoryLevel = new Model_FactoryLevel;

        $all_factories = $mFactoryLevel->getAllActive();
        $factory_level = $this->game->game_data->factory;

        $this->view->factory = $all_factories[$factory_level];

        if ($all_factories->offsetExists($factory_level - 1) && $factory_level > 1)
            $this->view->factory_down = $all_factories[$factory_level - 1];

        if ($all_factories->offsetExists($factory_level + 1))
            $this->view->factory_up = $all_factories[$factory_level + 1];

        $this->view->factory_level = $factory_level;
    }

    // Rozbudowa fabryki
    public function factoryUpgradeAction()
    {
        $this->loadGame();
        $mFactoryLevel = new Model_FactoryLevel;

        $all_factories = $mFactoryLevel->getAllActive();
        $factory_level = $this->game->game_data->factory;

        if ($all_factories->offsetExists($factory_level + 1)) {
            $factory = $all_factories[$factory_level + 1];
            if (($cash_before = $this->game->cash) >= $factory->cost) {
                $this->game->cash -= $factory->cost;
                $this->game->game_data->factory++;
                $this->game->game_data->history->factory[] = array(
                    'factory' => $this->game->game_data->factory,
                    'round' => $this->game->round,
                    'cash' => $this->game->cash,
                    'cash_before' => $cash_before
                );
                $this->game->updateProduction($factory->id);
                $this->game->save();
            }
        }
        $this->getGameData();
        die;
    }

    public function factoryDowngradeAction()
    {
        $this->loadGame();
        $mFactoryLevel = new Model_FactoryLevel;

        $all_factories = $mFactoryLevel->getAllActive();
        $factory_level = $this->game->game_data->factory;

        if ($all_factories->offsetExists($factory_level - 1) && $factory_level > 1) {
            $factory = $all_factories[$factory_level - 1];
            $this->game->game_data->factory--;
            $this->game->game_data->history->factory[] = array(
                'factory' => $this->game->game_data->factory,
                'round' => $this->game->round,
                'cash' => $this->game->cash,
                'cash_before' => $this->game->cash
            );
            $this->game->updateProduction($factory->id);
            $this->game->save();
        }

        $this->getGameData();
        die;
    }

    public function shopsAction()
    {
        $this->loadGame();

        $this->view->menu = array();

        $x = $this->view->posx = $this->_request->getParam('posx');
        $y = $this->view->posy = $this->_request->getParam('posy');

        if (isset($x) && isset($y)) {
            $map = $this->game->getGameMap();
            $shops = $map->getFieldsShops();
            if (isset($shops[$x][$y])) {
                $mShop = new Model_Shop;

                $all_shops = $mShop->getAllActive();
                $shop_level = $shops[$x][$y];

                if ($all_shops->offsetExists($shop_level))
                    $this->view->shop = $all_shops[$shop_level];

                if ($all_shops->offsetExists($shop_level - 1))
                    $this->view->shop_down = $all_shops[$shop_level - 1];

                if ($all_shops->offsetExists($shop_level + 1))
                    $this->view->shop_up = $all_shops[$shop_level + 1];

                $this->view->shop_level = $shop_level;

                $population = $map->getFieldsPopulation();
                $this->view->shop_population = $population[$x][$y];
            }
        }
    }

    // Budowanie/rozbudowa sklepu
    public function buildShopAction()
    {
        $this->loadGame();

        $x = $this->_request->getParam('posx');
        $y = $this->_request->getParam('posy');

        if (isset($x) && isset($y)) {
            $shops =& $this->gameMap->fields_shops;
            if (isset($shops[$x][$y]) && $shops[$x][$y] < 100) {
                $mShop = new Model_Shop;
                $all_shops = $mShop->getAllActive();
                $shop_level =& $shops[$x][$y];
                if ($all_shops->offsetExists($shop_level + 1)) {
                    $shop = $all_shops[$shop_level + 1];
                    if ($this->game->cash >= $shop->cost) {
                        $cash_before = $this->game->cash;
                        $this->game->cash -= $shop->cost;
                        $shop_level++;
                        $this->game->game_data->history->shops[] = array(
                            'shop' => $shop_level,
                            'posx' => $x,
                            'posy' => $y,
                            'round' => $this->game->round,
                            'cash' => $this->game->cash,
                            'cash_before' => $cash_before
                        );
                        $this->game->game_data->sale = $this->countShops($shops);
                        $this->game->save();

                        $this->gameMap->fields_shops = $shops;
                        $this->gameMap->save();
                    } else {
                        echo json_encode(array('no_cash' => 1));
                        die;
                    }
                }
            }
        }

        $this->getGameData();
        die;
    }

    public function countShops($shops)
    {
        $data = array();
        $mShop = new Model_Shop;
        $all_shops = $mShop->getAllActive();
        foreach ($shops as $r => $tmp) {
            foreach ($tmp as $c => $shop_level) {
                if ($shop_level > 0 && $shop_level < 100 && $all_shops->offsetExists($shop_level)) {
                    if (array_key_exists($shop_level, $data) == false) {
                        $shop = $all_shops[$shop_level];
                        $data[$shop_level] = array(
                            'count' => 0,
                            'staff' => $shop->staff,
                            'cost' => $shop->getStaffCost(),
                            'products' => $shop->getProducts(),
                            'sale' => $shop->getSale(),
                        );
                    }
                    $data[$shop_level]['count']++;
                }
            }
        }

        return $data;
    }

    public function downgradeShopAction()
    {
        $this->loadGame();

        $x = $this->_request->getParam('posx');
        $y = $this->_request->getParam('posy');

        if (isset($x) && isset($y)) {
            $shops =& $this->gameMap->fields_shops;
            if (isset($shops[$x][$y]) && $shops[$x][$y] < 100) {
                $mShop = new Model_Shop;

                $all_shops = $mShop->getAllActive();
                $shop_level =& $shops[$x][$y];

                if ($all_shops->offsetExists($shop_level - 1) && $shop_level > 0) {
                    $shop_level--;
                    $this->game->game_data->history->shops[] = array(
                        'shop' => $shop_level,
                        'posx' => $x,
                        'posy' => $y,
                        'round' => $this->game->round,
                        'cash' => $this->game->cash,
                        'cash_before' => $this->game->cash
                    );
                    $this->game->game_data->sale = $this->countShops($shops);
                    $this->game->save();

                    $this->gameMap->fields_shops = $shops;
                    $this->gameMap->save();
                }
            }
        }

        $this->getGameData();
        die;
    }

    public function removeShopAction()
    {
        $this->loadGame();

        $x = $this->_request->getParam('posx');
        $y = $this->_request->getParam('posy');

        if (isset($x) && isset($y)) {
            $shops =& $this->gameMap->fields_shops;
            if (isset($shops[$x][$y]) && $shops[$x][$y] < 100) {
                $shops[$x][$y] = 0;
                $this->game->game_data->history->shops[] = array(
                    'shop' => 0,
                    'posx' => $x,
                    'posy' => $y,
                    'round' => $this->game->round,
                    'cash' => $this->game->cash,
                    'cash_before' => $this->game->cash
                );
                $this->game->game_data->sale = $this->countShops($shops);
                $this->game->save();

                $this->gameMap->fields_shops = $shops;
                $this->gameMap->save();
            }
        }

        $this->getGameData();
        die;
    }

    public function deliveryAction()
    {
        $this->loadGame();
        $mDelivery = new Model_Delivery;
        $deliveries = $mDelivery->getAllActive();
        if ($this->_hasParam('delivery')) {
            foreach ($this->_getParam('delivery') as $k => $v) {
                if (!isset($deliveries[$k]))
                    continue;

                $this->game->game_data->delivery[$k] = array(
                    'quantity' => max(0, $v),
                    'cost'     => $deliveries[$k]->cost,
                    'capacity' => $deliveries[$k]->capacity,
                );
            }
            $this->game->save();
            $this->view->saved = true;
//            $this->getGameData();
//            die;
        }
        $this->view->deliveries = $deliveries;
    }

    public function bankAction()
    {
    }

    public function analyticsAction()
    {
        $this->loadGame();

        $mFactoryLevel = new Model_FactoryLevel;
        $this->view->factories = $mFactoryLevel->getAllActive();

        $mDelivery = new Model_Delivery;
        $this->view->deliveries = $mDelivery->getAllActive();

        $mShop = new Model_Shop;
        $this->view->shops = $mShop->getAllActive();

//        die('<pre>' . print_r($this->game->game_data, 1) . PHP_EOL);
//        die('<pre>' . print_r($this->view->deliveries, 1) . PHP_EOL);
//        die('<pre>' . print_r($this->gameMap->fields_shops, 1) . PHP_EOL);
    }

    public function quitAction()
    {
        $this->loadGame();
        $this->game->finished = date('Y-m-d H:i:s');
        $this->game->active = 0;
        $this->game->save();

        unset($this->ZendSession->game_id);

        $this->_flash($this->view->translate('Wyszedłeś z gry. Możesz wybrać nową misję'), 'success');
        $this->_redirectExit('index', 'index');
    }

    public function getGameData($echo = true)
    {
        $this->loadGame();

        $response = array(
            'cash' => $this->game->cash,
            'round' => $this->game->round,
            'sale' => $this->game->getMaxSale(),
            'actual_sale' => $this->game->getActualSale(),
            'factory' => $this->game->getFactoryProduction(),
            'delivery' => $this->game->getDeliveryCapacity(),
            'fields' => $this->game->getEconomy(),
            'population' => $this->game->getPopulation(),
            'buildings' => $this->game->getBuildings(),
            'game_data' => array(
                'factory' => $this->game->game_data->factory,
                'delivery' => $this->game->game_data->delivery,
                'production' => $this->game->game_data->production,
            )
        );
        if ($echo) {
            echo json_encode($response);
        } else {
            return $response;
        }
    }

    public function getGameDataAction()
    {
        $this->getGameData();
        die;
    }

    public function bankruptAction()
    {
        $this->loadGame();
        if ($this->game->bankrupt == 0)
            $this->_redirectExit('index');
    }

    public function nextRoundAction()
    {
        $this->loadGame();
        $gameData = $this->game->nextRound();
        $gameData = array_merge($this->getGameData(false), $gameData);
        echo json_encode($gameData);
        die;
    }

    public function backToTheFutureAction()
    {
        $this->loadGame();
        for ($x = 0; $x < 500; $x++) {
            $this->game->nextRound();
        }
        $this->game->save();
        $this->_redirect('/game');
    }

    public function latestAction()
    {
        if ($this->user == null)
            $this->_redirectExit('new');

        $game = $this->user->getLatestGame();
        if ($game == null) {
            $this->_flash($this->view->translate('Nie znaleziono gry.'), 'error');
            $this->_redirectBack();
        }

        $this->ZendSession->game_id = $game->id;
        if ($game->bankrupt)
            $this->_redirectExit('bankrupt');

        if ($game->mission_complete)
            $this->_redirectExit('mission-complete');

        if ($game->active == 0 || $game->finished) {
            $this->_flash('Gra została już zakończona lub jest nieaktywna.', 'error');
            $this->_redirectBack();
        }

        $this->_redirectExit('index');
    }


    public function continueAction()
    {
        if ($this->user == null)
            $this->_redirectExit('new');

        $mGame = new Model_Game;
        $game_id = $this->_request->getParam('game');
        if (isset($game_id)) {
            // Sprawdź czy stan gry istnieje w bazie danych oraz czy nalezy on do akurat zalogowanego usera
            $game = $mGame->getById($game_id);
            if (isset($game->id) && $game->user_id == $this->user->id) {
                $this->ZendSession->game_id = $game->id;
                if ($game->bankrupt == 1) {
                    $this->_redirect('/game/bankrupt');
                }
                if ($game->mission_complete == 1) {
                    $this->_redirect('/game/mission-complete');
                }
                if ($game->active != 0 && $game->finished == null) {
                    $this->_redirect('/game');
                }
            } elseif ($game->user_id != $this->user->id) {
                $this->_flash($this->view->translate('Nie jesteś autorem wskazanego stanu gry.'), 'error');
            } elseif ($game->active == 0 && $game->finished != null) {
                $this->_flash($this->view->translate('Gra jest nieaktywna.'), 'error');
            } else {
                $this->_flash($this->view->translate('Wystapił błąd podczas wczytywania.'), 'error');
            }
        }
        if (isset($_POST['delete'])) {
            $where = $mGame->getAdapter()->quoteInto('id IN(?)', $_POST['id']);
            if (isset($_POST['delete'])) {
                $mGame->delete($where);
                if (count($_POST['id']) > 1) {
                    $this->_flash($this->view->translate('%s stanów gier usunięto.', count($_POST['id'])), 'success');
                } else {
                    $this->_flash($this->view->translate('Stan gry usunięto.'), 'success');
                }
            }
        }
        $this->view->params = $mGame->_parseGamesParams($this->getRequest()->getParams());
        $this->ZendSession->languagesParams = $this->view->params;
        $this->view->items = $mGame->games($this->view->params, $this->user->id);
    }

    public function missionDetailsAction()
    {
        $this->loadGame();
    }

    public function missionCompleteAction()
    {
        $this->loadGame();

        if ($this->game->mission_complete == 0)
            $this->_redirectExit('index');

        if ($this->_request->isPost('email')) {
            $email = filter_input(INPUT_POST, 'email', FILTER_VALIDATE_EMAIL);
            if (empty($email)) {
                $this->_flash($this->view->translate('Nieprawidłowy adres email.'), 'error');
            } else {
                $this->sendMail($email);
                $this->_flash($this->view->translate('Twój wynik został wysłany pod wskazany adres e-mail.'), 'success');
            }
        }

        $this->view->canSendMail = $this->canSendMail();
    }

    /**
     * @return bool
     */
    protected function canSendMail()
    {
        $options = Zend_Registry::get('application_options');
        $options = $options['mail'];

        return $options['enabled'] || $this->getObserver();
    }

    /**
     * @param string $email
     * @return bool
     */
    protected function sendMail($email)
    {
        $options = Zend_Registry::get('application_options');
        $options = $options['mail'];

        if ($options['enabled'] == false)
            return false;

        $data = $this->getObserverData();
        $data['user_email'] = $email;

        if ($observer = $this->getObserver()) {
            $observer->observe('mission-complete', null, $data);
            return true;
        }

        if (!empty($options['smtp']) && !empty($options['config']['username']) && !empty($options['config']['password']))
            $transport = new Zend_Mail_Transport_Smtp($options['smtp'], $options['config']);
        else
            $transport = new Zend_Mail_Transport_Sendmail;

        $body = nl2br(file_get_contents(APPLICATION_PATH . '/configs/mail_mission_complete.txt'));
        $body = GN_Smekta::smektuj($body, $data);

        $mail = new Zend_Mail('utf-8');
        $mail->setBodyHtml($body);
        $mail->setSubject($options['subject']);
        $mail->setFrom($options['from']);
        $mail->addTo($email);
        $mail->send($transport);

        return true;
    }

    /**
     * @return array
     */
    protected function getObserverData()
    {
        if ($this->game == null)
            return array();

        $data = $this->game->calculateNextRound();
        $data = array(
            'game_cash' => $this->game->cash,
            'game_round' => $this->game->round,
            'game_factory_level' => $this->game->game_data->factory,
            'game_max_sale' => $data['MAX_SALE'],
            'game_max_capacity' => $data['MAX_CAPACITY'],
            'game_production' => $data['PRODUCTION'],
            'game_income' => $data['INCOME'],
            'game_costs' => $data['COSTS'],
            'game_shops_count' => $this->game->getShopsCount(),

            'game_mission_id' => $this->mission->id,
            'game_mission_name' => $this->mission->name(1),
        );

        if ($this->user) {
            $data['player_email'] = $data['user_email'] = $this->user->email;
            $data['player_name'] = $this->user->name;
        }

        if ($this->game->player_name) {
            $data['player_name'] = $this->game->player_name;
        }

        return $data;
    }

    /**
     * @return GN_Observer
     */
    protected function getObserver()
    {
        $observer = null;
        $googleapps = Zend_Registry::get('googleapps');
        if (isset($googleapps['json_link']) && $googleapps['json_hash']) {
            $observer = new GN_Observer(
                str_replace('{domain}', 'gammanet.pl', $googleapps['json_link']),
                $googleapps['json_hash'],
                $googleapps['admin'],
                null,
                'piekarz'
            );
        }
        return $observer;
    }
}
