<?php

class CreateTableMissionsLang extends Doctrine_Migration_Base
{
    private $_tableName = 'missions_lang';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'mission_id' => array(
                'type' => 'integer',
                'notnull' => true,
            ),
            'lang_id' => array(
                'type' => 'integer',
                'notnull' => true,
            ),
            'name' => array(
                'type' => 'character varying(256)',
                'notnull' => false,
            ),
            'description' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'description_done' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'description_failed' => array(
                'type' => 'text',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN lang_id SET DEFAULT 1');
	}

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
