<?php

class CreateTableGames extends Doctrine_Migration_Base
{
    private $_tableName = 'games';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'bitmap' => array(
                'type' => 'character varying(256)',
                'notnull' => false,
            ),
            'user_id' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'mission_id' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'mission_complete' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
            'cash' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'round' => array(
                'type' => 'integer',
                'notnull' => false,
            ),			
            'game_data' => array(
                'type' => 'text',
                'notnull' => false,
            ),
            'created' => array(
                'type' => 'timestamp',
                'notnull' => true,
            ),
            'finished' => array(
                'type' => 'timestamp',
                'notnull' => false,
            ),
            'bankrupt' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
            'active' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
		Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN created SET DEFAULT CURRENT_TIMESTAMP');							
		Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN finished SET DEFAULT NULL');							
    }

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
