<?php

class CreateTableBank extends Doctrine_Migration_Base
{
	private $_tableName = 'banks';
	
	function up()
	{
		$this->createTable($this->_tableName, array(
			'id' => array(
				'type' => 'integer',
				'primary' => true,
				'autoincrement' => true,
			),
			'cost' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'income' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'required_income' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'required_cash' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'required_round' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'required_factory' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'risk' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'duration' => array(
				'type' => 'integer',
				'notnull' => false,
			),
			'active' => array(
				'type' => 'smallint',
				'notnull' => false,
			),
		));
	}

	public function postUp()
	{
		Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
	}

	public function down()
	{
		$this->dropTable($this->_tableName);
	}
}

?>
