<?php

class Model_BankLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'banks_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByBankId($tax_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('bank_id = ?', $tax_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($tax_id)
    {
        $query = $this->select();
        $query->where('bank_id = ?', $tax_id);

        return $this->fetchAll($query);
    }

}

