<?php

class Model_Delivery extends Zend_Db_Table_Abstract
{
    protected $_name = 'deliveries';
    protected $_rowClass = 'Model_DeliveryRow';

    public function getById($id, $lang_id = 1)
    {
        $deliveryModel = new self();

        return $deliveryModel->fetchRow(array('id = ?' => $id));
    }

    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_DeliveryLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('d' => 'deliveries'), array('d.*'));
        $query->join(array('l' => 'deliveries_lang'), 'd.id = l.delivery_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->order('d.id ASC');
        return $this->fetchAll($query);
    }

    /**
     * @param int $lang_id
     * @return Zend_Db_Table_Rowset_Abstract|Model_DeliveryRow[]
     */
    public function getAllActive($lang_id = 1)
    {
        $languageTable = new Model_DeliveryLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('d' => 'deliveries'), array('d.*'));
        $query->join(array('l' => 'deliveries_lang'), 'd.id = l.delivery_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->where('d.active = ?', 1);
        $query->where('l.lang_id = ?', $lang_id);

        return $this->fetchAll($query);
    }

    function deliveries($params, $lang_id = 1)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $languageTable = new Model_DeliveryLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('d' => 'deliveries'), array('d.*'));
        $query->join(array('l' => 'deliveries_lang'), 'd.id = l.delivery_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        // TODO: dokończyć implementacje obslugi wielu języków
        $query->where('l.lang_id = ?', $lang_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'cash':
                    $query->order('cash');
                    break;
                case 'percent':
                    $query->order('percent');
                    break;
                case 'name':
                    $query->order('frequency');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    public function _parseDeliveriesParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

}

