<?php

class Model_DeliveryRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mDeliveryLang = new Model_DeliveryLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mDeliveryLang->getByDeliveryId($this->id, $lang_id);
            $data = array(
                'delivery_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mDeliveryLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mDeliveryLang->update($data, $where);
            } else {
                $mDeliveryLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mDeliveryLang = new Model_DeliveryLang;

        return $mDeliveryLang->getByDeliveryId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mDeliveryLang = new Model_DeliveryLang;

        return $mDeliveryLang->getByDeliveryId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mDeliveryLang = new Model_DeliveryLang;
        $where = $mDeliveryLang->getAdapter()->quoteInto('delivery_id = ?', $this->id);
        $mDeliveryLang->delete($where);
    }

}
