<?php

class Model_EventRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mEventLang = new Model_EventLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mEventLang->getByEventId($this->id, $lang_id);
            $data = array(
                'event_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mEventLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mEventLang->update($data, $where);
            } else {
                $mEventLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mEventLang = new Model_EventLang;

        return $mEventLang->getByEventId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mEventLang = new Model_EventLang;

        return $mEventLang->getByEventId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mEventLang = new Model_EventLang;
        $where = $mEventLang->getAdapter()->quoteInto('event_id = ?', $this->id);
        $mEventLang->delete($where);
    }

}
