<?php

class Model_FactoryLevelLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'factory_levels_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByFactoryLevelId($factory_level_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('factory_level_id = ?', $factory_level_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($factory_level_id)
    {
        $query = $this->select();
        $query->where('factory_level_id = ?', $factory_level_id);

        return $this->fetchAll($query);
    }

}

