<?php

class Model_FactoryLevelRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mFactoryLevelLang = new Model_FactoryLevelLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mFactoryLevelLang->getByFactoryLevelId($this->id, $lang_id);
            $data = array(
                'factory_level_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mFactoryLevelLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mFactoryLevelLang->update($data, $where);
            } else {
                $mFactoryLevelLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mFactoryLevelLang = new Model_FactoryLevelLang;

        return $mFactoryLevelLang->getByFactoryLevelId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mFactoryLevelLang = new Model_FactoryLevelLang;

        return $mFactoryLevelLang->getByFactoryLevelId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mFactoryLevelLang = new Model_FactoryLevelLang;
        $where = $mFactoryLevelLang->getAdapter()->quoteInto('factory_level_id = ?', $this->id);
        $mFactoryLevelLang->delete($where);
    }

    /**
     * @return int
     */
    public function getProduction()
    {
        return $this->getTable()->getAdapter()->fetchOne('SELECT SUM(production) FROM factory_products WHERE factory_id = ' . $this->id);
    }

    /**
     * @return int
     */
    public function getStaffCost()
    {
        $app = Zend_Registry::get('app');
        return $app['salary'] * $this->staff;
    }

}
