<?php

class Model_Game extends Zend_Db_Table_Abstract
{
    protected $_name = 'games';
    protected $_rowClass = 'Model_GameRow';

    /**
     * @param $id
     * @param int $lang_id
     * @return Model_GameRow
     */
    public function getById($id, $lang_id = 1)
    {
        return $this->find($id)->current();
    }

    /**
     * @param null $session_id
     * @return Model_GameRow
     */
    public function getBySessionId($session_id = null)
    {
        if ($session_id == null)
            $session_id = session_id();

        return $this->fetchRow(array(
            'session_id = ?' => $session_id,
            'mission_complete = ?' => 0,
            'bankrupt = ?' => 0,
            'active = ?' => 1
        ), 'created DESC');
    }

    /**
     * @param int $mission_id
     * @param int $user_id
     * @param int $cash
     * @return Model_GameRow
     */
    public function createNewGame($mission_id, $user, $cash = 10000)
    {
        if (isset($mission_id)) {
            $mMission = new Model_Mission;
            $mMap = new Model_Map;
            $mGameMap = new Model_GameMap;
            // 1. Pobierz dane misji z bazy danych
            $mission = $mMission->getById($mission_id);
            if ($mission == null)
                throw new Exception('Nie znaleziono misji o podanym ID');

            $map = $mMap->getById($mission->map_id);

            // 1.2 Tablica z wielkością produkcji dla fabryki #1
            $mFactoryLevel = new Model_FactoryLevel;
            $factories = $mFactoryLevel->getAll();
            $factory = $factories->offsetGet(1);
            $mFactoryProduct = new Model_FactoryProduct;
            $production = $mFactoryProduct->byFactoryId($factory->id)->toArray();
            // 2. Generuj nowy wpis w bazie danych
            $game_data = array(
                'session_id' => session_id(),
                'mission_id' => $mission_id,
                'mission_complete' => 0,
                'cash' => $cash,
                'round' => 1,
                'game_data' => array(
                    'time_started' => time(),
                    'factory' => 1,
                    'factory_staff' => $factory->staff,
                    'production' => $production,
                    'delivery' => array(),
                    'sale' => array(),
                    'month' => 1,
                    'day' => 1,
                    'bankrupt_counter' => 0,
                    'history' => array(
                        'shops' => array(),
                        'factory' => array(),
                        'events' => array(),
                        'opponent' => array(),
                        'taxes' => array(),
                        'production' => array(),
                        'delivery' => array(),
                        'bookkeeping' => array(),
                        'sale' => array(),
                        'sale_total' => array(),
                    ),
                ),
                'bankrupt' => 0,
                'active' => 1
            );
            if ($user)
                $game_data['user_id'] = $user->id;

            $game = $this->createRow();
            $game->setFromArray($game_data);
            $game->save();

            $population = $shops = $staff = array();
            // 3. Generowanie mapy
            foreach ($map->getFields() as $y => $row) {
                foreach ($row as $x => $field) {
                    if ($field < 100) {
                        $population[$y][$x] = $field * 30 + rand(1, 100); // Tutaj ustawiasz wielkość populacji na starcie!
                        $shops[$y][$x] = 0;
                    } else {
                        $population[$y][$x] = '';
                        $shops[$y][$x] = $field;
                    }
                    $staff[$y][$x] = 0;
                }
            }
            $game_map_data = array(
                'game_id' => $game->id,
                'fields_population' => $population,
                'fields_shops' => $shops,
                'fields_staff' => $staff,
            );
            $map = $mGameMap->createRow();
            $map->setFromArray($game_map_data);
            $map->save();

            return $game;
        }
    }

    /**
     * @param int $lang_id
     * @return Zend_Db_Table_Rowset_Abstract
     */
    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_GameLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('g' => 'games'), array('g.*'));
        $query->join(array('m' => 'game_maps'), 'g.id = m.game_id', array(
            'm.game_id',
            'm.fields_economy',
            'm.fields_population',
            'm.fields_shops',
            'm.fields_staff'
        ));

        return $this->fetchAll($query);
    }

    /**
     * @param array $params
     * @param bool $user_id
     * @return Zend_Paginator
     */
    function games($params, $user_id = false)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $game_maps = new Model_GameMap;
        $query = $game_maps->select()->setIntegrityCheck(false);
        $query->from(array('g' => 'games'), array('g.*'));
        $query->join(array('m' => 'game_maps'), 'g.id = m.game_id', array(
            'm.game_id',
            'm.fields_economy',
            'm.fields_population',
            'm.fields_shops',
            'm.fields_staff'
        ));
        $query->where('g.user_id = ?', $user_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'cash':
                    $query->order('cash');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    /**
     * @param array $params
     * @return array
     */
    public function _parseGamesParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

    public function deBug($array)
    {
        echo '<pre>';
        print_r($array);
        die;
    }

}

