<?php

class Model_Language extends Zend_Db_Table_Abstract
{
    protected $_name = 'languages';

    /**
     * @param $id
     * @return null|Zend_Db_Table_Row_Abstract
     */
    public function findById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);
        $result = $this->fetchRow($query);

        return $result;
    }

    public function getById($id)
    {
        return $this->findById($id);
    }

    public function getAll()
    {
        $query = $this->select();
        $result = $this->fetchAll($query);

        return $result;
    }

    public function getAllActive()
    {
        $query = $this->select();
        $query->where('active = ?', 1);
        $result = $this->fetchAll($query);

        return $result;
    }

    function languages($params)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $query = $this->select();
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'iso_code':
                    $query->order('iso_code');
                    break;
                case 'language_code':
                    $query->order('language_code');
                    break;
                case 'name':
                    $query->order('name');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        if (isset($params['iso_code'])) {
            $query->where('LOWER(iso_code) = LOWER(?)', $params['iso_code']);
        }

        if (isset($params['language_code'])) {
            $query->where('LOWER(language_code) = LOWER(?)', $params['language_code']);
        }

        if (isset($params['name'])) {
            $query->where('LOWER(name) = LOWER(?)', $params['name']);
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    public function _parseLanguagesParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

}

