<?php

class Model_Map extends Zend_Db_Table_Abstract
{
    protected $_name = 'maps';
    protected $_rowClass = 'Model_MapRow';

    public function getById($id, $lang_id = 1)
    {
        $modelMap = new self();

        return $modelMap->fetchRow(array('id = ?' => $id));
    }

    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_TaxLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('m' => 'maps'), array('m.*'));
        $query->join(array('l' => 'maps_lang'), 'm.id = l.map_id', array(
            'l.name',
            'l.description'
        ));

        return $this->fetchAll($query);
    }

    function maps($params, $lang_id = 1)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $languageTable = new Model_MapLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('m' => 'maps'), array('m.*'));
        $query->join(array('l' => 'maps_lang'), 'm.id = l.map_id', array(
            'l.name',
            'l.description'
        ));
        // TODO: dokończyć implementacje obslugi wielu języków
        $query->where('l.lang_id = ?', $lang_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'bitmap':
                    $query->order('bitmap');
                    break;
                case 'width':
                    $query->order('width');
                    break;
                case 'height':
                    $query->order('height');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    public function _parseMapsParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

}

