<?php

class Model_MapLang extends Zend_Db_Table_Abstract
{
    protected $_name = 'maps_lang';

    public function getById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);

        return $this->fetchRow($query);
    }

    public function getByMapId($map_id, $lang_id = false)
    {
        $query = $this->select();
        $query->where('map_id = ?', $map_id);
        if ($lang_id) {
            $query->where('lang_id = ?', $lang_id);

            return $this->fetchRow($query);
        } else {
            return $this->fetchAll($query);
        }
    }

    public function getAll()
    {
        $query = $this->select();

        return $this->fetchAll($query);
    }

    public function getTranslations($map_id)
    {
        $query = $this->select();
        $query->where('map_id = ?', $map_id);

        return $this->fetchAll($query);
    }

}

