<?php

class Model_MapRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mMapLang = new Model_MapLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mMapLang->getByMapId($this->id, $lang_id);
            $data = array(
                'map_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mMapLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mMapLang->update($data, $where);
            } else {
                $mMapLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mMapLang = new Model_MapLang;

        return $mMapLang->getByMapId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mMapLang = new Model_MapLang;

        return $mMapLang->getByMapId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mMapLang = new Model_MapLang;
        $where = $mMapLang->getAdapter()->quoteInto('map_id = ?', $this->id);
        $mMapLang->delete($where);
    }

    /**
     * @return array
     */
    public function getFields()
    {
        return json_decode($this->fields);
    }
}
