<?php

class Model_MissionRow extends Zend_Db_Table_Row_Abstract
{

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mMissionLang = new Model_MissionLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mMissionLang->getByMissionId($this->id, $lang_id);
            $data = array(
                'mission_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mMissionLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mMissionLang->update($data, $where);
            } else {
                $mMissionLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mMissionLang = new Model_MissionLang;

        return $mMissionLang->getByMissionId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mMissionLang = new Model_MissionLang;

        return $mMissionLang->getByMissionId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mMissionLang = new Model_MissionLang;
        $where = $mMissionLang->getAdapter()->quoteInto('mission_id = ?', $this->id);
        $mMissionLang->delete($where);
    }

}
