<?php

class Model_Product extends Zend_Db_Table_Abstract
{
    protected $_name = 'products';
    protected $_rowClass = 'Model_ProductRow';

    public function getById($id, $lang_id = 1)
    {
        $languageTable = new Model_ProductLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('p' => 'products'), array('p.*'));
        $query->join(array('l' => 'products_lang'), 'p.id = l.product_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->where('p.id =?', $id);

        return $this->fetchRow($query);
    }

    public function getNames($arr = array(), $lang_id = 1)
    {
        $names = array();
        foreach ($arr as $k => $v) {
            $names[$v->product_id] = $this->getById($v->product_id);
        }

        return $names;
    }

    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_ProductLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('p' => 'products'), array('p.*'));
        $query->join(array('l' => 'products_lang'), 'p.id = l.product_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));

        return $this->fetchAll($query);
    }

    public function getAllActive()
    {
        $query = $this->select();
        $query->where('active = ?', 1);
        $query->order('id');
        $result = $this->fetchAll($query);

        return $result;
    }

    function products($params, $lang_id = 1)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $languageTable = new Model_ProductLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('p' => 'products'), array('p.*'));
        $query->join(array('l' => 'products_lang'), 'p.id = l.product_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        // TODO: dokończyć implementacje obslugi wielu języków
        $query->where('l.lang_id = ?', $lang_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'cost':
                    $query->order('cost');
                    break;
                case 'profit':
                    $query->order('profit');
                    break;
                case 'weight':
                    $query->order('weight');
                    break;
                case 'factory_level_id':
                    $query->order('factory_level_id');
                    break;
                case 'shop_level_id':
                    $query->order('shop_level_id');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    public function _parseProductsParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }

}

