<?php

class Model_Shop extends Zend_Db_Table_Abstract
{
    protected $_name = 'shops';
    protected $_rowClass = 'Model_ShopRow';

    public function getById($id, $lang_id = 1)
    {
        $shopModel = new self();

        return $shopModel->fetchRow(array('id = ?' => $id));
    }

    /**
     * @param int $lang_id
     * @return Zend_Db_Table_Rowset_Abstract
     */
    public function getAll($lang_id = 1)
    {
        $languageTable = new Model_ShopLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('s' => 'shops'), array('s.*'));
        $query->join(array('l' => 'shops_lang'), 's.id = l.shop_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->order('s.id');
        return $this->fetchAll($query);
    }

    /**
     * @param int $lang_id
     * @return Zend_Db_Table_Rowset_Abstract
     */
    public function getAllActive($lang_id = 1)
    {
        $languageTable = new Model_ShopLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('s' => 'shops'), array('s.*'));
        $query->join(array('l' => 'shops_lang'), 's.id = l.shop_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        $query->where('s.active = ?', 1);
        $query->order('s.id');

        return $this->fetchAll($query);
    }

    /**
     * @param $params
     * @param int $lang_id
     * @return Zend_Paginator
     */
    function shops($params, $lang_id = 1)
    {
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }
        if (!isset($params['page'])) {
            $params['page'] = 1;
        }
        $languageTable = new Model_ShopLang;
        $query = $languageTable->select()->setIntegrityCheck(false);
        $query->from(array('s' => 'shops'), array('s.*'));
        $query->join(array('l' => 'shops_lang'), 's.id = l.shop_id', array(
            'l.lang_id',
            'l.name',
            'l.description'
        ));
        // TODO: dokończyć implementacje obslugi wielu języków
        $query->where('l.lang_id = ?', $lang_id);
        if (isset($params['sort'])) {
            switch ($params['sort']) {
                case 'cost':
                    $query->order('cost');
                    break;
                case 'profit':
                    $query->order('profit');
                    break;
                case 'weight':
                    $query->order('weight');
                    break;
                case 'factory_level_id':
                    $query->order('factory_level_id');
                    break;
                case 'shop_level_id':
                    $query->order('shop_level_id');
                    break;
                case 'active':
                    $query->order('active');
                    break;
                case 'id':
                default:
                    $query->order('id');
                    break;
            }
        } else {
            $query->order('id');
        }

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbTableSelect($query));

        $paginator->setItemCountPerPage($params['perPage']);
        $paginator->setCurrentPageNumber($params['page']);

        return $paginator;
    }

    /**
     * @param $params
     * @return mixed
     */
    public function _parseShopsParams($params)
    {
        // Domyślnie chcemy wyświetlać po 5 rekordów na stronę
        if (!isset($params['perPage'])) {
            $params['perPage'] = 20;
        }

        // Filtrujemy puste wartości
        foreach ($params as $key => $value) {
            if (is_null($value) or $value == '') {
                unset($params[$key]);
                continue;
            }
            switch ($key) {
                case 'module':
                case 'controller':
                case 'action':
                case 'submit':
                    // Te dane nie będą nam potrzebne - usuwamy
                    unset($params[$key]);
                    continue;
                    break;
            }
        }

        return $params;
    }
}

