<?php

class Model_ShopProduct extends Zend_Db_Table_Abstract
{
    protected $_name = 'shop_products';

    /**
     * @param $id
     * @return null|Zend_Db_Table_Row_Abstract
     */
    public function findById($id)
    {
        $query = $this->select();
        $query->where('id = ?', $id);
        $result = $this->fetchRow($query);

        return $result;
    }

    public function getById($id)
    {
        return $this->findById($id);
    }

    public function byProductId($id)
    {
        $query = $this->select();
        $query->where('product_id = ?', $id);
        $result = $this->fetchAll($query);

        return $result;
    }

    public function byShopId($id)
    {
        $query = $this->select();
        $query->where('shop_id = ?', $id);
        $result = $this->fetchAll($query);

        return $result;
    }

    public function getAll()
    {
        $query = $this->select();
        $result = $this->fetchAll($query);

        return $result;
    }

}

