<?php

class Model_ShopRow extends Zend_Db_Table_Row_Abstract
{
    /**
     * @var int
     */
    protected $_sale;

    /**
     * @var array
     */
    protected $_products;

    public function saveTranslations($lang_ids, $names, $descriptions)
    {
        $mShopLang = new Model_ShopLang;
        foreach ($lang_ids as $key => $lang_id) {
            $translate = $mShopLang->getByShopId($this->id, $lang_id);
            $data = array(
                'shop_id' => $this->id,
                'lang_id' => $lang_id,
                'name' => $names[$key],
                'description' => $descriptions[$key]
            );
            if (isset($translate->id)) {
                $where = $mShopLang->getAdapter()->quoteInto('id = ?', $translate->id);
                $mShopLang->update($data, $where);
            } else {
                $mShopLang->insert($data);
            }
        }
    }

    public function loadTranslations()
    {
        $mShopLang = new Model_ShopLang;

        return $mShopLang->getByShopId($this->id);
    }

    public function getTranslation($lang_id = false)
    {
        $mShopLang = new Model_ShopLang;

        return $mShopLang->getByShopId($this->id, $lang_id);
    }

    public function name($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->name;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->name;
            }
        }

        return $translation;
    }

    public function description($lang_id = false)
    {
        if ($lang_id) {
            $translation = $this->getTranslation($lang_id);
            $translation = $translation->description;
        } else {
            $translations = $this->getTranslation();
            foreach ($translations as $t) {
                $translation[$t->lang_id] = $t->description;
            }
        }

        return $translation;
    }

    public function deleteTranslations()
    {
        $mShopLang = new Model_ShopLang;
        $where = $mShopLang->getAdapter()->quoteInto('shop_id = ?', $this->id);
        $mShopLang->delete($where);
    }

    /**
     * @return int
     */
    public function getSale()
    {
        if ($this->_sale == null)
            $this->_sale = $this->getTable()->getAdapter()->fetchOne('SELECT SUM(sale) FROM shop_products WHERE shop_id = ' . $this->id);

        return $this->_sale;
    }

    /**
     * @return int
     */
    public function getStaffCost()
    {
        $app = Zend_Registry::get('app');
        return $app['salary'] * $this->staff;
    }

    /**
     * @param int $lang_id
     * @return array
     */
    public function getProducts($lang_id = 1)
    {
        if ($this->_products == null)
            $this->_products = $this->getTable()->getAdapter()->fetchAll('SELECT products.id, shop_products.sale, products.cost, products.profit, products.weight, products_lang.name
            FROM products
            INNER JOIN products_lang ON products_lang.product_id = products.id
            INNER JOIN shop_products ON shop_products.product_id = products.id
            WHERE shop_products.shop_id = ?
            AND products_lang.lang_id = ?', array($this->id, $lang_id));

        return $this->_products;
    }
}
