<?php

class Zend_View_Helper_Items extends Zend_View_Helper_Abstract
{

    public function Items($target = false, $headers = false, $items = false, $columns = false, $menu = false, $link = false, $link_parameter_name = "id", $hide_checkboxes = false)
    {
        if ($target && $headers && $items && $columns && $menu && $link && count($items) > 0) {
            echo '<div class="items_list">';
            echo '<form method="post" action="' . $target . '">';
            echo '<div class="search_form"></div>';
            echo '<div class="sort"></div>';
            echo '<table>';
            echo '<theader>';
            echo '<th class="first_column"><input type="checkbox" id="SelectAll" /></th>';

            $column_index = 0;
            foreach ($headers as $key => $header) {
                $c = '';
                if (isset($columns[$column_index]) && $columns[$column_index] != null) {
                    $c = ' class="' . $columns[$column_index] . '"';
                }
                echo '<th' . $c . '>' . $header . '</th>';
                $column_index++;
            }

            echo '</theader>';
            echo '<tbody>';
            $c = '';
            foreach ($items as $key => $object) {
                try {
                    $item = $object->toArray();
                    $a = '<a href="' . $this->view->baseUrl($link . '/' . $link_parameter_name . '/' . $item['id']) . '" title="' . $this->view->translate('Klikenij by edytować') . '">';
                    $c = ('odd' != $c) ? 'odd' : 'even';
                    echo '<tr class="' . $c . '">';
                    echo '<td class="first_column">';
                    if ($hide_checkboxes && ($hide_checkboxes == $item['id'] || in_array($hide_checkboxes, $item['id']))) {
                    } else {
                        echo '<input type="checkbox" name="id[]" value="' . $item['id'] . '" />';
                    }
                    echo '</td>';
                    $column_index = 0;
                    foreach ($item as $k => $v) {
                        if ($k != 'description' && $k != 'lang_id') {
                            $cc = '';
                            if (isset($columns[$column_index]) && $columns[$column_index] != null) {
                                $cc = ' class="' . $columns[$column_index] . '"';
                            }
                            echo '<td' . $cc . '>' . $a;
                            switch ($k) {
                                case 'active':
                                    switch ($v) {
                                        case 1:
                                            echo $this->view->translate('aktywny');
                                            break;
                                        default:
                                            echo $this->view->translate('nieaktywny');
                                            break;
                                    }
                                    break;
                                case 'allow_once':
                                    switch ($v) {
                                        case 1:
                                            echo $this->view->translate('tylko raz');
                                            break;
                                        default:
                                            echo $this->view->translate('wiele razy');
                                            break;
                                    }
                                    break;
                                default:
                                    echo $v;
                            }
                            echo '</a></td>';
                            $column_index++;
                        }
                    }
                    echo '</tr>';
                } catch (Exception $e) {
                }
            }
            echo '</tbody>';
            echo '</table>';
            echo '</div>';
            $this->view->Menu($menu, 'FormMenu');
            echo '<script>
				$(document).ready(function() {
					$(\'#FormMenu\').hide();					
					$(\'#SelectAll\').click(function(){
						if($(this).is(\':checked\')) {
							$("table input[type=\'checkbox\']").attr(\'checked\', true);
						} else {
							$("table input[type=\'checkbox\']").attr(\'checked\', false);
						}
					});
					$("input[type=\'checkbox\']").change(function () {  
						if ($("input:checkbox:checked").length > 0) {
							$(\'#FormMenu\').show();
						} else {
							$(\'#FormMenu\').hide();
						}
					});
					$(".items_list form").submit(function(){
						if(confirm("' . $this->view->translate('Jesteś pewnien?') . '")) {
							return true;
						} else {
							return false;
						}
					});
				});
				</script>' . "\n";
            echo '</form>';
        }
    }

}
