<?php

class GN_Validate_Gapps_String extends Zend_Validate_Regex
{
    const CASE_LOWER   = -1;
    const CASE_DEFAULT =  0;
    const CASE_UPPER   =  1;
    
    /**
     * @var Boolean
     */
    protected $_unpolish = true;

    protected $_case = 0;

    public function __construct()
    {
        parent::__construct('/^[a-zA-Z0-9 -]+$/');

        $this->setMessage("Value expected to be a string", self::INVALID);
        $this->setMessage("Value can contain only letters, digits, spaces and '-'", self::NOT_MATCH);
    }

    public function setUnpolish(bool $unpolish)
    {
        $this->_unpolish = $unpolish;
        return $this;
    }

    public function getUnpolish()
    {
        return $this->_unpolish;
    }

    public function setCase($case)
    {
        $this->_case = $case;
        return $this;
    }

    public function getCase()
    {
        return $this->_case;
    }

    public function isValid($value)
    {
        if ($this->getUnpolish()) {
            $value = self::unpolish($value, $this->getCase());
        }

        return parent::isValid($value);
    }

    public static function unpolish($text, $case = self::CASE_DEFAULT)
    {
        $acc = 'É	Ê	Ë	š	Ì	Í	ƒ	œ	µ	Î	Ï	ž	Ð	Ÿ	Ñ	Ò	Ó	Ô	Š	£	Õ	Ö	Œ	¥	Ø	Ž	§	À	Ù	Á	Ú	Â	Û	Ã	Ü	Ä	Ý	';
        $str = 'E	E	E	s	I	I	f	o	m	I	I	z	D	Y	N	O	O	O	S	L	O	O	O	Y	O	Z	S	A	U	A	U	A	U	A	U	A	Y	';

        $acc .= 'Å	Æ	ß	Ç	à	È	á	â	û	Ĕ	ĭ	ņ	ş	Ÿ	ã	ü	ĕ	Į	Ň	Š	Ź	ä	ý	Ė	į	ň	š	ź	å	þ	ė	İ	ŉ	Ţ	Ż	æ	ÿ	';
        $str .= 'A	A	S	C	a	E	a	a	u	E	i	n	s	Y	a	u	e	I	N	S	Z	a	y	E	i	n	s	z	a	p	e	I	n	T	Z	a	y	';

        $acc .= 'Ę	ı	Ŋ	ţ	ż	ç	Ā	ę	Ĳ	ŋ	Ť	Ž	è	ā	Ě	ĳ	Ō	ť	ž	é	Ă	ě	Ĵ	ō	Ŧ	ſ	ê	ă	Ĝ	ĵ	Ŏ	ŧ	ë	Ą	ĝ	Ķ	ŏ	';
        $str .= 'E	l	n	t	z	c	A	e	I	n	T	Z	e	a	E	i	O	t	z	e	A	e	J	o	T	i	e	a	G	j	O	t	e	A	g	K	o	';

        $acc .= 'Ũ	ì	ą	Ğ	ķ	Ő	ũ	í	Ć	ğ	ĸ	ő	Ū	î	ć	Ġ	Ĺ	Œ	ū	ï	Ĉ	ġ	ĺ	œ	Ŭ	ð	ĉ	Ģ	Ļ	Ŕ	ŭ	ñ	Ċ	ģ	ļ	ŕ	Ů	';
        $str .= 'U	i	a	G	k	O	u	i	C	g	k	o	U	i	c	G	L	O	u	i	C	g	l	o	U	o	c	G	L	R	u	n	C	g	l	r	U	';

        $acc .= 'ò	ċ	Ĥ	Ľ	Ŗ	ů	ó	Č	ĥ	ľ	ŗ	Ű	ô	č	Ħ	Ŀ	Ř	ű	õ	Ď	ħ	ŀ	ř	Ų	ö	ď	Ĩ	Ł	Ś	ų	Đ	ĩ	ł	ś	Ŵ	ø	đ	';
        $str .= 'o	c	H	L	R	u	o	C	h	l	r	U	o	c	H	L	R	u	o	D	h	l	r	U	o	d	I	L	S	c	D	i	l	s	W	o	d	';

        $acc .= 'Ī	Ń	Ŝ	ŵ	ù	Ē	ī	ń	ŝ	Ŷ	Ə	ú	ē	Ĭ	Ņ	Ş	ŷ';
        $str .= 'I	N	S	w	u	E	i	n	s	Y	e	u	e	I	N	S	y';

        $acc .= 'Б	б	В	в	Г	г	Д	д	Ё	ё	Ж	ж	З	з	И	и	Й	й	К	к	Л	л	М	м	Н	н	П	п	О	о	Р	р	С	с	Т	т	У	у	Ф	ф	Х	х	Ц	ц	Ч	ч	Ш	ш	Щ	щ	Ъ	Ы	ы	Ь	Э	э	Ю	ю	Я	я';
        $str .= 'B	b	W	w	G	g	D	d	Yo	yo	Z	z	Z	z	I	i	N	n	K	k	L	l	M	m	H	h	P	p	O	o	P	p	S	s	T	t	U	u	f	F	Ch	h	C	c	C	c	Sz	sz	S	s	-	Y	y	-	E	e	Iu	iu	Ia	ia';

        $out = str_replace(explode("\t", $acc), explode("\t", $str), $text);

        if ($case == self::CASE_LOWER)
            return strtolower($out);
        else if ($case == self::CASE_UPPER)
            return strtoupper($out);
        else
            return ($out);
    }
}