<?php
require_once 'Zend/Gdata/App/Base.php';

class Zend_Gdata_Acl_AdditionalRole extends Zend_Gdata_App_Base
{
    protected $_value;
    protected $_entryClassName = 'Zend_Gdata_Acl_AdditionalRole';
    protected $_rootNamespace = 'gAcl';
    protected $_rootElement = 'additionalRole';

    public function __construct($roleValue=null)
    {
        $this->registerNamespace('gAcl', 'http://schemas.google.com/acl/2007');
        if ($roleValue !== null) {
            $this->setValue($roleValue);
        }
        parent::__construct();
    }

    public function getDOM($doc = null, $majorVersion = 1, $minorVersion = null)
    {
        $element = parent::getDOM($doc, $majorVersion, $minorVersion);
        if ($this->_value !== null) {
            $element->setAttribute('value', $this->_value);
        }
        return $element;
    }

    protected function takeAttributeFromDOM($attribute)
    {
        switch ($attribute->localName) {
            case 'value':
                $this->_value = $attribute->nodeValue;
                break;
            default:
                parent::takeAttributeFromDOM($attribute);
        }
    }

    public function setValue($value)
    {
        $this->_value = $value;
        return $this;
    }

    public function getValue()
    {
        return $this->_value;
    }
}

