(function ($) {
    $.fn.extend({
        drawMap: function (o) {
            var defaults = {
                cols: 1,
                rows: 1,
                round: 1,
                fields: [],
                population: [],
                buildings: [],
                baseUrl: '',
                duration: 12000,
                colors: ["green", "orange", "red"]
            }
            var o = $.extend(defaults, o);

            return this.each(function()
            {
                var map = $(this);

                // Rusyj mapę!
                function redrawMap()
                {
                    var fieldsClass = map.children(".fields").attr("class");
                    if (fieldsClass == "" || fieldsClass == undefined)
                        fieldsClass = "fields";

                    map.children(".fields").remove();

                    var fieldsContainer = $("<div></div>").addClass(fieldsClass);
                    if (map.attr("id") != "InactiveMap")
                        fieldsContainer.addClass("fields_hidden");

                    var map_w = map.width();
                    var map_h = map.height();
                    var field_w = map_w / o.cols;
                    var field_h = map_h / o.rows;

                    for (var r = 0; r < o.rows; r++)
                    {
                        var fieldsRow = $("<div></div>").attr("id", "FieldsRow_" + r)
                                                        .addClass("fields_row")
//                                                        .css({width : map_w + field_w, height : field_h});

                        for (var c = 0; c < o.cols; c++)
                        {
                            var field = $("<div></div>").attr("id","Fields_" + c + "_" + r)
                                                        .addClass("field")
                                                        .addClass("fields_column_" + c)
                                                        .addClass("tooltip")
//                                                        .css({width : field_w, height : field_h});


                            // Określ kolor pola i wpisz wielkośc populacji
                            var pop = $("<div></div>").addClass("field_population").appendTo(field);
                            if (o.fields[r] != undefined && o.fields[r][c] != undefined)
                            {
                                pop.text(o.population[r][c]);
                                switch (o.fields[r][c])
                                {
                                    case 1:
                                        field.addClass("bad_field")
                                             .attr("original-title", o.strings.POPULATION_IS + ' ' + o.population[r][c] + ' ' + o.strings.TOOLTIP_NEW_SHOP);
                                        break;
                                    case 2:
                                        field.addClass("medium_field")
                                             .attr("original-title", o.strings.POPULATION_IS + ' ' + o.population[r][c] + ' ' + o.strings.TOOLTIP_NEW_SHOP);
                                        break;
                                    case 3:
                                        field.addClass("good_field")
                                             .attr("original-title", o.strings.POPULATION_IS + ' ' + o.population[r][c] + ' ' + o.strings.TOOLTIP_NEW_SHOP);
                                        break;
                                }
                            }
                            // narysuj budynek
                            var info  = $("<div></div>").addClass("field_info").appendTo(field);
                            if (o.buildings[r] != undefined && o.buildings[r][c] != undefined)
                            {
                                var level = $("<div></div>").addClass("field_level");

                                if (o.buildings[r][c] == 200) {
                                    info.addClass("field_info_cardepot");
                                    pop.text("");
                                    field.addClass("car_depot_field")
                                         .attr("original-title", o.strings.TOOLTIP_DELIVERY)
                                }

                                if (o.buildings[r][c] > 0 && o.buildings[r][c] < 100) {
                                    level.text(o.buildings[r][c]).appendTo(info);
                                    info.addClass("field_info_shop");
                                }

                                if (o.buildings[r][c] >= 100 && o.buildings[r][c] < 200) {
                                    level.text(o.game_data.factory).appendTo(info);
                                    pop.text("");
                                    info.addClass("field_info_factory");
                                    field.addClass("factory_field")
                                         .attr("original-title", o.strings.TOOLTIP_FACTORY)
                                }

                                if (o.buildings[r][c] >= 500 && o.buildings[r][c] < 600) {
                                    level.text(o.buildings[r][c] - 499).appendTo(info);
                                    info.addClass("field_info_opponent");
                                    field.attr("original-title", o.strings.TOOLTIP_OPPONENT);
                                }
                            }

                            field.click(onFieldClick(r, c));
                            fieldsRow.append(field);
                        }
                        fieldsContainer.append(fieldsRow);
                    }
                    map.append(fieldsContainer);
                    $("div.tipsy").remove();
                    $(".tooltip").tipsy({
                        gravity: $.fn.tipsy.autoWE
                    });

                    $(".fields_row").css({"width" : map_w + field_w, "height" : field_h});
                    $(".field").css({"width" : field_w, "height" : field_h});
                    $(".field_population").css({"line-height" : field_h + "px"});
                }

                $("<div><div></div></div>").addClass("progress_bar").appendTo("li.top_bar_round div.top_bar_container");

                var top_menu_ul = $("ul.top_bar_menu");
                var top_menu_li = $("li.top_bar_menu");

                top_menu_ul.find("li").click(toggleTopBarMenu);
                top_menu_ul.find(".analytics").click(showAnalyticsDetails)
                top_menu_ul.find(".objectives").click(showMissionDetails);
                top_menu_ul.find(".back").click(function(e){
                    window.location = BASE_URL;
                });
                top_menu_ul.find(".quit").click(function(e){
                    if (confirm(o.strings.QUIT))
                        window.location = BASE_URL + "game/quit"
                });
                top_menu_ul.find(".ranking").click(function(e){
                    window.open(BASE_URL + "rank");
                });
                top_menu_ul.find(".user_guide").click(function(e){
                    window.open(BASE_URL + "podrecznik_gracza.pdf");
                });

                top_menu_li.click(toggleTopBarMenu);

                function toggleTopBarMenu()
                {
                    if (top_menu_li.hasClass("active")) {
                        top_menu_li.removeClass("active");
                        top_menu_ul.hide();
                    } else {
                        top_menu_li.addClass("active");
                        top_menu_ul.show();
                    }
                }

                $.fn.countDown = function (settings, to) {
                    settings = jQuery.extend({
                        startWidth: "100",
                        endWidth: "0",
                        duration: 12000,
                        startNumber: 1,
                        callBack: function () {
                        }
                    }, settings);
                    return this.each(function()
                    {
                        function ajaxNextRound()
                        {
                            $.getJSON(BASE_URL + "game/next-round", function (data) {
                                updateMapData(data);
                                if (data.game_over != null) {
                                    if (data.game_over.bankrupt == 1) {
                                        alert(o.strings.BANKRUPT);
                                        window.location.href = BASE_URL + "game/bankrupt";
                                        return;
                                    }
                                    if (data.game_over.mission_complete == 1) {
                                        if (data.game_over.mission_objectives == 1) {
                                            alert(o.strings.MISSION_OBJECTIVES);
                                        } else {
                                            alert(o.strings.MISSION_COMPLETE);
                                        }
                                        window.location.href = BASE_URL + "game/mission-complete";
                                        return;
                                    }
                                }
                                if (data.event != null) {
                                    var alert_message = data.event.name + "\n";
                                    if (data.event.description != "") {
                                        alert_message = alert_message + data.event.description + "\n\n";
                                    }
                                    if (data.event.cash < 0) {
                                        alert_message = alert_message + o.strings.YOU_LOSE + ": " + data.event.event_cash + " " + CURRENCY;
                                    } else  {
                                        alert_message = alert_message + o.strings.YOU_EARN + ": " + data.event.event_cash + " " + CURRENCY;
                                    }
                                    alert(alert_message);
                                }
                                redrawMap();
                            });
                        }

                        if (to == null)
                            to = settings.startNumber;

                        $(this).css("width", settings.startWidth + "%");
                        $(this).parent('div.progress_bar').parent('div').children('span.top_bar_value').text(to);
                        $(this).parent('div.progress_bar').click(function () {
                            $(this).children('div').stop().animate({
                                width: settings.endWidth
                            }, 1000, "", function () {
                                jQuery(this).css("width", settings.startWidth + "%").countDown(settings, parseInt(to) + 1);
                                ajaxNextRound();
                            });
                        });
                        $(this).animate({
                            width: settings.endWidth
                        }, settings.duration, "", function () {
                            jQuery(this).css("width", settings.startWidth + "%").countDown(settings, parseInt(to) + 1);
                            ajaxNextRound();
                        });
                    });
                };

                function onFieldClick(x, y)
                {
                    return function (e)
                    {
                        var field = $(this);
                        field.addClass("selected_field");
                        if (field.hasClass("factory_field")) {
                            showFactoryDetails();
                        } else if (field.hasClass("car_depot_field")) {
                            showDeliveryDetails();
                        } else {
                            showShopDetails(x, y);
                        }
                    }
                }

                function refreshData()
                {
                    $.getJSON(BASE_URL + "game/get-game-data", function (data) {
                        updateMapData(data);
                        redrawMap();
                    });
                }

                $("div.progress_bar div").countDown({
                    startNumber: o.round,
                    duration: o.duration,
                    callBack: function (me) {
                    }
                });

                $(".top_bar_fields").click(function () {
                    var item = $(this);
                    if (item.hasClass("menu_off")) {
                        item.addClass("menu_on").removeClass("menu_off");
                        map.children('.fields').toggleClass("fields_hidden");
                    } else {
                        item.addClass("menu_off").removeClass("menu_on");
                        map.children('.fields').toggleClass("fields_hidden");
                    }
                    return false;
                });

                function updateMapData(data)
                {
                    var helper = [
                        { name : "sale", value : data.sale },
                        { name : "delivery", value : data.delivery },
                        { name : "factory", value : data.factory }
                    ].sort(function(a, b) {
                        return (b.value - a.value);
                    });
                    var topBar = $("#GameDetails div ul");
                    for (var i = 0; i < helper.length; i++) {
                        var tmp = topBar.find("li.top_bar_" + helper[i].name + " .top_bar_value");
                        if (helper[i].name == "sale") {
                            tmp.html("<span>" + data.actual_sale + "</span> / " + helper[i].value);
                            tmp = tmp.find("span");
                        } else {
                            tmp.html(helper[i].value);
                        }
                        tmp.css("color", o.colors[i]);
                    }

                    if (data.cash != undefined)
                        topBar.find("li.top_bar_cash .top_bar_value").text(data.cash + " " + o.strings.CURRENCY);

                    o = $.extend(o, data);
                }

                function showDeliveryDetails(data)
                {
                    showPopup(560);

                    function updateDeliveryCost()
                    {
                        var deliveryCost = 0, deliveryCapacity = 0;
                        $("#Popup .typeWrapper .counter input:hidden[data]").each(function(k, v){
                            var tmp = $(this).attr("data").split(":");
                            deliveryCapacity += $(this).val() * tmp[0];
                            deliveryCost += $(this).val() * tmp[1];
                        });

                        $("#Popup .summary .green span").text(deliveryCapacity);
                        $("#Popup .summary .red span").text(deliveryCost);
                    }

                    $("#PopupContent").load(BASE_URL + "game/delivery #Content", data || {}, function () {
                        centerPopup();

                        if (data)
                            $(".saved").fadeIn().delay(1000).fadeOut();

                        var popup = $("#Popup");
                        $(popup).find(".typeWrapper .counter").each(function(){
                            var val = $(this).find(".value");
                            var inp = $(this).find("input:hidden");

                            $(this).find(".plus").click(function(e){
                                var v = val.text() * 1 + 1;
                                val.text(v);
                                inp.val(v);
                                updateDeliveryCost();
                            });

                            $(this).find(".minus").click(function(e){
                                var v = Math.max(0, val.text() * 1 - 1);
                                val.text(v);
                                inp.val(v);
                                updateDeliveryCost();
                            });
                        });

                        $(popup).find(".cancel").click(closePopup);
                        $(popup).find(".accept").click(function(e){
                            var data = {};
                            $(popup).find("input:hidden").each(function(k, v){
                                data[$(this).attr("name")] = $(this).val();
                            });
                            showDeliveryDetails(data);
                            refreshData();
                        });
                    });
                }

                function showFactoryDetails()
                {
                    showPopup(500);
                    $("#PopupContent").load(BASE_URL + "game/factory #Content", showBuildingDetails);
                }

                function showShopDetails(x, y)
                {
                    showPopup(500);
                    $("#PopupContent").load(BASE_URL + "game/shops/posx/" + x + "/posy/" + y + " #Content", showBuildingDetails);
                }

                function showBuildingDetails()
                {
                    centerPopup();

                    $("#PopupContent span.downgrade").mouseenter(function(e){
                        $(".shop-up").hide();
                        $(".shop-down").show();
                    }).mouseleave(function(e){
                        $(".shop-up").show();
                        $(".shop-down").hide();
                    });

                    $("#PopupContent span.button").click(function(e){
                        var link = $(this).attr("href");
                        if (confirm(o.strings.ARE_YOU_SURE)) {
                            $.getJSON(link, function (data) {
                                if (data.no_cash) {
                                    alert(o.strings.NO_CASH);
                                } else {
                                    refreshData();
                                    closePopup();
                                }
                            });
                        }
                        return false;
                    });
                }

                function showMissionDetails()
                {
                    showPopup(500);
                    $("#PopupContent").load(BASE_URL + "game/mission-details #Content", centerPopup);
                }

                function showAnalyticsDetails()
                {
                    showPopup(950);
                    $("#PopupContent").load(BASE_URL + "game/analytics #Content", centerPopup);
                }

                $(window).resize(redrawMap);
                refreshData();
            });
        }
    });
})(jQuery);
