<?php
/**
 * @author Radosław Szczepaniak <radoslaw.szczepaniak@gammanet.pl>
 */

class RankController extends GN_Controller
{
    public function init()
    {
        parent::init();

        Zend_View_Helper_PaginationControl::setDefaultViewPartial('paginator.phtml');
        Zend_Paginator::setDefaultItemCountPerPage(20);
        Zend_Paginator::setDefaultScrollingStyle('Sliding');
    }

    public function indexAction()
    {
        /**
         * @var Zend_Db_Table_Abstract $db
         */
        $db = Zend_Registry::get('db');
        $select = $db->select()
            ->from('games', array('id', 'round', 'cash', 'profit'))
            ->joinLeft('users', 'users.id = games.user_id', null)
            ->joinLeft('missions', 'missions.id = games.mission_id', null)
            ->joinLeft('missions_lang', 'missions_lang.mission_id = missions.id AND missions_lang.lang_id = 1', array('mission_name' => 'name'))
            ->columns(array(
                'player_name' => new Zend_Db_Expr('COALESCE(users.name, games.player_name)')
            ))
            ->where('games.finished IS NOT NULL')
            ->where('games.mission_objectives = 1')
            ->where('games.mission_complete = 1')
            ->where('games.bankrupt = 0')
            ->where('games.active = 0');

        $sortDir = strtolower($this->_getParam('sort_dir'));
        if (empty($sortDir) || !in_array($sortDir, array('asc', 'desc')))
            $sortDir = 'desc';

        $sortBy = $this->_getParam('sort_by');
        if (empty($sortBy) || !in_array($sortBy, array('cash', 'profit')))
            $sortBy = 'cash';

        $select->order($sortBy . ' ' . $sortDir);

        $paginator = new Zend_Paginator(new Zend_Paginator_Adapter_DbSelect($select));
        $paginator->setCurrentPageNumber($this->_getParam('page', 1));

        $this->view->paginator = $paginator;
        $this->view->startLp   = $paginator->getItemCountPerPage() * ($paginator->getCurrentPageNumber() - 1);
        $this->view->sortBy    = $sortBy;
        $this->view->sortDir   = $sortDir;
    }
}