<?php

class CreateTableTaxes extends Doctrine_Migration_Base
{
    private $_tableName = 'taxes';
    
    function up()
    {
        $this->createTable($this->_tableName, array(
            'id' => array(
                'type' => 'integer',
                'primary' => true,
                'autoincrement' => true,
            ),
            'cash' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'percent' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'frequency' => array(
                'type' => 'integer',
                'notnull' => false,
            ),
            'active' => array(
                'type' => 'smallint',
                'notnull' => false,
            ),
        ));
    }

    public function postUp()
    {
        Doctrine_Manager::connection()->exec('ALTER TABLE ' . $this->_tableName . ' ALTER COLUMN active SET DEFAULT 1');
    }

    public function down()
    {
        $this->dropTable($this->_tableName);
    }
}

?>
